/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontFamily;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FontFamily
implements IFontFamily {
    private final IFont[] fonts = new IFont[4];
    private String name = "";
    private String type = "";

    public FontFamily(String name) {
        this.name = name;
    }

    @Override
    public String getFamilyName() {
        return this.name;
    }

    @Override
    public IFont getFont(FontStyle style) {
        return this.fonts[style.getIndex()];
    }

    public Iterator<IFont> getFontIterator() {
        return new Iterator<IFont>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                while (this.index < FontFamily.this.fonts.length) {
                    if (FontFamily.this.fonts[this.index] != null) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public IFont next() {
                while (this.index < FontFamily.this.fonts.length) {
                    if (FontFamily.this.fonts[this.index] != null) {
                        return FontFamily.this.fonts[this.index++];
                    }
                    ++this.index;
                }
                throw new NoSuchElementException("no more fonts");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("can not remove font");
            }
        };
    }

    @Override
    public IFont[] getFonts() {
        ArrayList<IFont> result = new ArrayList<IFont>();
        for (int i = 0; i < this.fonts.length; ++i) {
            if (this.fonts[i] == null) continue;
            result.add(this.fonts[i]);
        }
        return result.toArray(new IFont[result.size()]);
    }

    @Override
    public FontStyle[] getFontStyles() {
        ArrayList<FontStyle> result = new ArrayList<FontStyle>();
        for (int i = 0; i < this.fonts.length; ++i) {
            if (this.fonts[i] == null) continue;
            result.add(this.fonts[i].getFontStyle());
        }
        return result.toArray(new FontStyle[result.size()]);
    }

    @Override
    public String getFontType() {
        return this.type;
    }

    @Override
    public void registerFont(IFont font) {
        this.fonts[font.getFontStyle().getIndex()] = font;
        this.type = font.getFontType();
    }

    public String toString() {
        return String.format("%s(name=%s, type=%s)", this.getClass().getSimpleName(), this.name, this.type);
    }
}

