/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

public class FontStyle {
    public static final int COUNT = 4;
    public static final FontStyle UNDEFINED = new FontStyle("?", -1, false, false);
    public static final FontStyle REGULAR = new FontStyle("Regular", 0, false, false);
    public static final FontStyle ITALIC = new FontStyle("Italic", 1, true, false);
    public static final FontStyle BOLD = new FontStyle("Bold", 2, false, true);
    public static final FontStyle BOLD_ITALIC = new FontStyle("BoldItalic", 3, true, true);
    private final boolean bold;
    private FontStyle boldFlavor = null;
    private final String id;
    private final int index;
    private final boolean italic;
    private FontStyle italicFlavor = null;

    public static FontStyle getFontStyle(String name) {
        if (name == null) {
            return REGULAR;
        }
        name = name.trim().toLowerCase();
        boolean bold = false;
        boolean italic = false;
        if (name.indexOf("bold") >= 0) {
            bold = true;
        }
        if (name.indexOf("italic") >= 0) {
            italic = true;
        }
        if (name.indexOf("oblique") >= 0) {
            italic = true;
        }
        if (bold) {
            if (italic) {
                return BOLD_ITALIC;
            }
            return BOLD;
        }
        if (italic) {
            return ITALIC;
        }
        return REGULAR;
    }

    private FontStyle(String label, int index, boolean italic, boolean bold) {
        this.id = label;
        this.index = index;
        this.italic = italic;
        this.bold = bold;
    }

    public FontStyle getBoldFlavor() {
        return this.boldFlavor;
    }

    public String getId() {
        return this.id;
    }

    protected int getIndex() {
        return this.index;
    }

    public FontStyle getItalicFlavor() {
        return this.italicFlavor;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public String toString() {
        return this.getId();
    }

    static {
        FontStyle.REGULAR.italicFlavor = ITALIC;
        FontStyle.REGULAR.boldFlavor = BOLD;
        FontStyle.ITALIC.italicFlavor = ITALIC;
        FontStyle.ITALIC.boldFlavor = BOLD_ITALIC;
        FontStyle.BOLD.italicFlavor = BOLD_ITALIC;
        FontStyle.BOLD.boldFlavor = BOLD;
        FontStyle.BOLD_ITALIC.italicFlavor = BOLD_ITALIC;
        FontStyle.BOLD_ITALIC.boldFlavor = BOLD_ITALIC;
    }
}

