/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.CommonFontStore;
import de.intarsys.cwt.font.IFontRegistry;
import de.intarsys.cwt.freetype.Library;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathFontStore
extends CommonFontStore {
    private static final Logger Log = LoggerFactory.getLogger(PathFontStore.class);
    private Path path;

    public PathFontStore(Path path) {
        this.path = path;
    }

    @Override
    public void load(Library library, IFontRegistry fontRegistry, Object logPrefix) {
        this.loadFontPath(library, fontRegistry, logPrefix);
    }

    protected void loadFontDirectory(Library library, IFontRegistry fontRegistry, Object logPrefix) {
        if (!Files.exists(this.path, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(this.path, new LinkOption[0])) {
            return;
        }
        try {
            Files.newDirectoryStream(this.path).forEach(file -> this.loadFontFile(library, fontRegistry, logPrefix, (Path)file));
        }
        catch (IOException ex) {
            Log.warn("{} error looking up font files in {}", new Object[]{logPrefix, this.path, ex});
        }
    }

    protected void loadFontFile(Library library, IFontRegistry fontRegistry, Object logPrefix, Path file) {
        if (!Files.isRegularFile(file, LinkOption.NOFOLLOW_LINKS)) {
            return;
        }
        this.loadFontUnchecked(library, fontRegistry, logPrefix, file.toAbsolutePath().toString());
    }

    protected void loadFontPath(Library library, IFontRegistry fontRegistry, Object logPrefix) {
        if (Files.isDirectory(this.path, new LinkOption[0])) {
            this.loadFontDirectory(library, fontRegistry, logPrefix);
        } else if (Files.isRegularFile(this.path, new LinkOption[0])) {
            this.loadFontUnchecked(library, fontRegistry, logPrefix, this.path.toAbsolutePath().toString());
        }
    }
}

