/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.ClassLoaderFontStore;
import de.intarsys.cwt.font.FontRegistry;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.IFontEnvironment;
import de.intarsys.cwt.font.IFontRegistry;
import de.intarsys.cwt.font.IProviderBasedFontStore;
import de.intarsys.cwt.font.PathFontStore;
import de.intarsys.cwt.freetype.Freetype;
import de.intarsys.cwt.freetype.Library;
import de.intarsys.tools.provider.ProviderTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.system.SystemTools;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFontEnvironment
implements IFontEnvironment {
    private static final Logger Log = LoggerFactory.getLogger(StandardFontEnvironment.class);
    private static final Path[] SystemFontDirectories = SystemTools.isMac() ? new Path[]{Paths.get("/System/Library/Fonts", new String[0]), Paths.get("/Library/Fonts", new String[0]), Paths.get(System.getProperty("user.home"), "Library", "Fonts")} : (SystemTools.isWindows() ? new Path[]{Paths.get(System.getenv("WINDIR"), "Fonts")} : new Path[0]);
    private List<ClassLoader> fontClassLoaders = new ArrayList<ClassLoader>();
    private List<Path> fontDirectories = new ArrayList<Path>();
    private List<Path> fontFiles = new ArrayList<Path>();
    private boolean registeredSystem = false;
    private boolean registeredUser = false;

    public StandardFontEnvironment() {
        this.registerFontClassLoader(this.getClass().getClassLoader());
    }

    public synchronized ClassLoader[] getFontClassLoaders() {
        return this.fontClassLoaders.toArray(new ClassLoader[this.fontClassLoaders.size()]);
    }

    public synchronized Path[] getFontDirectories() {
        return this.fontDirectories.toArray(new Path[this.fontDirectories.size()]);
    }

    public synchronized Path[] getFontFiles() {
        return this.fontFiles.toArray(new Path[this.fontFiles.size()]);
    }

    protected Object getLogPrefix() {
        return "FontEnvironment";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFontMapClassLoader(Library library, ClassLoader loader) {
        try {
            Enumeration<URL> urls = loader.getResources("fonts/fonts.maps");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream is = null;
                try {
                    is = url.openStream();
                    this.parseMaps(library, loader, is);
                }
                catch (IOException ex) {
                    Log.warn("{} error loading 'fonts/fonts.maps' from '{}'", new Object[]{this.getLogPrefix(), url, ex});
                }
                finally {
                    StreamTools.close((Closeable)is);
                }
            }
        }
        catch (IOException ex) {
            Log.warn("{} error looking up 'font/fonts.maps' resources", this.getLogPrefix(), (Object)ex);
        }
    }

    protected void loadSystemFonts(Library library) {
        IFontRegistry fontRegistry = FontRegistry.get();
        for (Path directory : SystemFontDirectories) {
            Log.debug("{} load system font directory {}", this.getLogPrefix(), (Object)directory.toAbsolutePath());
            new PathFontStore(directory).load(library, fontRegistry, this.getLogPrefix());
        }
        ProviderTools.providers(IProviderBasedFontStore.class).forEachRemaining(fontStore -> {
            if (fontStore.isSupported()) {
                fontStore.load(library, fontRegistry, this.getLogPrefix());
            }
        });
    }

    protected void loadUserFonts(Library library) {
        Path[] paths;
        IFontRegistry fontRegistry = FontRegistry.get();
        for (Path directory : paths = this.getFontDirectories()) {
            Log.debug("{} load user font directory {}", this.getLogPrefix(), (Object)directory.toAbsolutePath());
            new PathFontStore(directory).load(library, fontRegistry, this.getLogPrefix());
        }
        for (Path file : paths = this.getFontFiles()) {
            new PathFontStore(file).load(library, fontRegistry, this.getLogPrefix());
        }
        ClassLoader[] loaders = this.getFontClassLoaders();
        for (int i = 0; i < loaders.length; ++i) {
            ClassLoader loader = loaders[i];
            new ClassLoaderFontStore(loader).load(library, fontRegistry, this.getLogPrefix());
            this.loadFontMapClassLoader(library, loader);
        }
    }

    protected void parseMaps(Library library, ClassLoader loader, InputStream is) throws IOException {
        String map;
        StringBuilder sb = new StringBuilder();
        int i = is.read();
        while (i != -1) {
            if (i == 10) {
                map = sb.toString().trim();
                this.processFontMap(library, loader, map);
                sb.setLength(0);
                i = is.read();
                continue;
            }
            sb.append((char)i);
            i = is.read();
        }
        map = sb.toString().trim();
        this.processFontMap(library, loader, map);
    }

    protected void processFontMap(Library library, ClassLoader loader, String map) throws IOException {
        if (map.length() == 0 || map.startsWith("#")) {
            return;
        }
        String[] split = map.split("\\=");
        if (split.length < 2) {
            return;
        }
        FontTools.mapAlias(split[0], split[1]);
    }

    public synchronized void registerFontClassLoader(ClassLoader loader) {
        this.fontClassLoaders.add(loader);
    }

    @Deprecated
    public synchronized void registerFontDirectory(File directory) {
        this.registerFontDirectory(directory.toPath());
    }

    public synchronized void registerFontDirectory(Path directory) {
        this.fontDirectories.add(directory);
    }

    @Deprecated
    public synchronized void registerFontFile(File file) {
        this.registerFontFile(file.toPath());
    }

    public synchronized void registerFontFile(Path file) {
        this.fontFiles.add(file);
    }

    @Override
    public synchronized boolean registerSystemFonts() {
        if (this.registeredSystem) {
            return false;
        }
        this.registeredSystem = true;
        try {
            Library library = Freetype.initFreeType();
            try {
                this.loadSystemFonts(library);
            }
            finally {
                library.doneFreeType();
            }
            return true;
        }
        catch (Throwable t) {
            Log.warn("{} failed to register system fonts", this.getLogPrefix(), (Object)t);
            return false;
        }
    }

    @Override
    public synchronized boolean registerUserFonts() {
        if (this.registeredUser) {
            return false;
        }
        this.registeredUser = true;
        try {
            Library library = Freetype.initFreeType();
            try {
                this.loadUserFonts(library);
            }
            finally {
                library.doneFreeType();
            }
            return true;
        }
        catch (Throwable t) {
            Log.warn("{} failed to register user fonts", this.getLogPrefix(), (Object)t);
            return false;
        }
    }
}

