/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.FontMap;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontMapper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFontMapper
implements IFontMapper {
    private static final Logger Log = LoggerFactory.getLogger(StandardFontMapper.class);
    private Map<String, FontMap> fontMaps = new HashMap<String, FontMap>();

    @Override
    public IFont lookupFont(String name) {
        IFont result = null;
        FontMap fontMap = this.fontMaps.get(this.normalize(name));
        if (fontMap != null) {
            result = fontMap.getFont();
        }
        if (result == null) {
            Log.trace("font map missed " + name);
        } else {
            Log.trace("font map found " + name);
        }
        return result;
    }

    protected String normalize(String name) {
        if (name == null) {
            return null;
        }
        return name.toLowerCase();
    }

    @Override
    public void registerFontMap(FontMap map) {
        this.fontMaps.put(this.normalize(map.getKey()), map);
    }
}

