/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.IImageConverter;
import de.intarsys.cwt.image.ImageConvertOption;
import de.intarsys.cwt.image.ImageException;
import de.intarsys.tools.provider.Providers;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class CommonImage<I extends IImage, II>
implements IImage {
    private Map<Class<?>, IImage> images;
    protected final II baseImage;
    private final Class<I> type;
    private final AffineTransform transform;

    protected CommonImage(II baseImage, Class<I> type) {
        this.baseImage = baseImage;
        this.type = type;
        this.transform = null;
        this.images = new HashMap();
    }

    protected CommonImage(II baseImage, Class<I> type, AffineTransform transform) {
        this.baseImage = baseImage;
        this.type = type;
        this.transform = transform;
        this.images = new HashMap();
    }

    @Override
    public <T extends IImage> T asImage(Class<T> type, ImageConvertOption ... options) {
        if (type.isAssignableFrom(this.type)) {
            return (T)this;
        }
        IImage image = this.images.get(type);
        if (image == null) {
            image = this.createImage(type, options);
            this.images.put(type, image);
        }
        return (T)image;
    }

    protected <T extends IImage> T createImage(Class<T> type, ImageConvertOption ... options) {
        Iterator iterator = Providers.get().lookupProviders(IImageConverter.class);
        while (iterator.hasNext()) {
            IImageConverter candidate = (IImageConverter)iterator.next();
            if (!candidate.acceptSourceImage(this) || !candidate.acceptTargetType(type)) continue;
            IImageConverter imageConverter = candidate;
            return imageConverter.convertImage(this, options);
        }
        throw new ImageException("cannot convert image");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGraphics(IGraphicsContext graphicsContext, float x, float y) {
        AffineTransform transform = this.getTransform();
        AffineTransform previousTransform = null;
        if (transform != null) {
            previousTransform = graphicsContext.getTransform();
            graphicsContext.transform(transform);
        }
        try {
            graphicsContext.drawImage(this, (int)x, (int)y);
        }
        finally {
            if (previousTransform != null) {
                graphicsContext.setTransform(previousTransform);
            }
        }
    }

    protected II getBaseImage() {
        return this.baseImage;
    }

    @Deprecated
    protected II getMasterImage() {
        return this.getBaseImage();
    }

    @Override
    public Class<I> getType() {
        return this.type;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }
}

