/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image;

import de.intarsys.cwt.common.IGraphics;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.image.PACKAGE;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.string.StringTools;
import java.awt.Color;
import java.awt.geom.Line2D;

public class ImageErrorGraphics
implements IGraphics {
    private int width;
    private int height;
    private String text;

    public ImageErrorGraphics(int width, int height) {
        this(width, height, PACKAGE.Msg.getString("ImageErrorGraphics.defaultText", new Object[0]));
    }

    public ImageErrorGraphics(int width, int height, String text) {
        this.width = width;
        this.height = height;
        this.text = text;
    }

    public ImageErrorGraphics(int width, int height, Throwable t) {
        this(width, height, PACKAGE.Msg.getString("ImageErrorGraphics.throwableText", new Object[]{ExceptionTools.getMessageShort((Throwable)t)}));
    }

    @Override
    public void drawGraphics(IGraphicsContext graphicsContext, float x, float y) {
        graphicsContext.setForegroundColor(Color.DARK_GRAY);
        graphicsContext.draw(new Line2D.Double(x, y, (float)this.width + x, (float)this.height + y));
        graphicsContext.draw(new Line2D.Double((float)this.width + x, y, x, (float)this.height + y));
        if (!StringTools.isEmpty((String)this.text)) {
            graphicsContext.drawString(this.text, x, (float)this.height + y);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

