/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image;

import de.intarsys.cwt.image.ImageException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Node;

public class ImageTools {
    public static String extractJPEGColorSpaceType(ImageReader reader) throws IOException {
        IIOMetadata metadata;
        try {
            metadata = reader.getImageMetadata(0);
        }
        catch (RuntimeException ex) {
            throw new ImageException(ex);
        }
        catch (IIOException ex) {
            throw new ImageException(ex);
        }
        Node node = metadata.getAsTree("javax_imageio_1.0");
        Node allegedChromaNode = node.getFirstChild();
        if (allegedChromaNode == null) {
            throw new ImageException("color space not declared (chroma node missing in jpeg metadata)");
        }
        while (!allegedChromaNode.getLocalName().equals("Chroma")) {
            if ((allegedChromaNode = allegedChromaNode.getNextSibling()) != null) continue;
            throw new ImageException("color space not declared (chroma node missing in jpeg metadata)");
        }
        Node allegedColorNode = allegedChromaNode.getFirstChild();
        if (allegedColorNode == null) {
            throw new ImageException("color space not declared (color space node missing in jpeg metadata)");
        }
        while (!allegedColorNode.getLocalName().equals("ColorSpaceType")) {
            if ((allegedColorNode = allegedColorNode.getNextSibling()) != null) continue;
            throw new ImageException("color space not declared (color space node missing in jpeg metadata)");
        }
        Node name = allegedColorNode.getAttributes().getNamedItem("name");
        if (name == null) {
            throw new ImageException("color space not declared");
        }
        return name.getNodeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractJPEGColorSpaceType(InputStream stream) throws IOException {
        try (ImageInputStream imageStream = ImageIO.createImageInputStream(stream);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(imageStream);
            if (!readers.hasNext()) {
                throw new ImageException("no reader for this image type");
            }
            ImageReader reader = readers.next();
            try {
                imageStream.reset();
                reader.setInput(imageStream);
                String string = ImageTools.extractJPEGColorSpaceType(reader);
                reader.dispose();
                return string;
            }
            catch (Throwable throwable) {
                reader.dispose();
                throw throwable;
            }
        }
    }
}

