/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image.svg;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.image.CommonImage;
import de.intarsys.cwt.image.svg.ISvgImage;
import de.intarsys.cwt.image.svg.Svg;
import de.intarsys.cwt.image.svg.SvgShape;
import java.awt.BasicStroke;
import java.awt.Color;

public class CwtSvgImage
extends CommonImage<ISvgImage, Svg> {
    public CwtSvgImage(Svg baseImage) {
        super(baseImage, ISvgImage.class);
    }

    @Override
    public void drawGraphics(IGraphicsContext graphicsContext, float x, float y) {
        boolean strokeChanged = false;
        for (SvgShape shape : ((Svg)this.getBaseImage()).getShapes()) {
            Color fill = shape.getFillColor();
            Color stroke = shape.getStrokeColor();
            if (fill == null) {
                if (stroke == null) continue;
                graphicsContext.setForegroundColor(stroke);
                if (shape.getStroke() == null) {
                    if (strokeChanged) {
                        graphicsContext.setStroke(new BasicStroke(1.0f, 0, 0, 4.0f));
                        strokeChanged = false;
                    }
                } else {
                    graphicsContext.setStroke(shape.getStroke());
                    strokeChanged = true;
                }
                graphicsContext.draw(shape.getEffectiveShape());
                continue;
            }
            graphicsContext.setBackgroundColor(fill);
            if (stroke == null) {
                graphicsContext.fill(shape.getEffectiveShape());
                continue;
            }
            graphicsContext.setForegroundColor(stroke);
            if (shape.getStroke() == null) {
                if (strokeChanged) {
                    graphicsContext.setStroke(new BasicStroke(1.0f, 0, 0, 4.0f));
                    strokeChanged = false;
                }
            } else {
                graphicsContext.setStroke(shape.getStroke());
                strokeChanged = true;
            }
            graphicsContext.fillDraw(shape.getEffectiveShape());
        }
    }

    @Override
    public int getHeight() {
        return (int)Math.ceil(((Svg)this.getBaseImage()).getHeight());
    }

    @Override
    public int getWidth() {
        return (int)Math.ceil(((Svg)this.getBaseImage()).getWidth());
    }
}

