/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image.svg;

import de.intarsys.cwt.image.svg.SvgRootHandler;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.sax.SAXAbstractElementHandler;
import de.intarsys.tools.string.StringTools;
import java.awt.BasicStroke;
import java.awt.Color;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SvgElementHandler
extends SAXAbstractElementHandler {
    private static final String ATTR_FILL = "fill";
    private static final String ATTR_STROKE = "stroke";
    private static final String ATTR_STROKE_LINECAP = "stroke-linecap";
    private static final String ATTR_STROKE_LINEJOIN = "stroke-linejoin";
    private static final String ATTR_STROKE_MITERLIMIT = "stroke-miterlimit";
    private static final String ATTR_STROKE_WIDTH = "stroke-width";
    private static final String STROKE_LINECAP_BUTT = "butt";
    private static final String STROKE_LINECAP_ROUND = "round";
    private static final String STROKE_LINECAP_SQUARE = "square";
    private static final String STROKE_LINEJOIN_BEVEL = "bevel";
    private static final String STROKE_LINEJOIN_MITER = "miter";
    private static final String STROKE_LINEJOIN_ROUND = "round";
    private Color fillColor;
    private BasicStroke stroke;
    private Color strokeColor;

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public Color getFillColor() {
        if (this.fillColor == null && this.getParentElementHandler() != null) {
            return this.getParentElementHandler().getFillColor();
        }
        return this.fillColor;
    }

    public SvgElementHandler getParentElementHandler() {
        return (SvgElementHandler)super.getParent();
    }

    public SvgRootHandler getRootHandler() {
        return this.getParentElementHandler().getRootHandler();
    }

    public BasicStroke getStroke() {
        if (this.stroke == null && this.getParentElementHandler() != null) {
            return this.getParentElementHandler().getStroke();
        }
        return this.stroke;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void processAttributes(Attributes attrs) throws SAXException {
        try {
            String strokeString;
            String fillString = attrs.getValue(ATTR_FILL);
            if (!StringTools.isEmpty((String)fillString)) {
                this.fillColor = (Color)ConverterRegistry.get().convert((Object)fillString, Color.class);
            }
            if (!StringTools.isEmpty((String)(strokeString = attrs.getValue(ATTR_STROKE)))) {
                this.strokeColor = (Color)ConverterRegistry.get().convert((Object)strokeString, Color.class);
            }
        }
        catch (ConversionException ex) {
            throw new SAXException((Exception)((Object)ex));
        }
        String widthString = attrs.getValue(ATTR_STROKE_WIDTH);
        String linecapString = attrs.getValue(ATTR_STROKE_LINECAP);
        String linejoinString = attrs.getValue(ATTR_STROKE_LINEJOIN);
        String miterlimitString = attrs.getValue(ATTR_STROKE_MITERLIMIT);
        if (!(StringTools.isEmpty((String)widthString) && StringTools.isEmpty((String)linecapString) && StringTools.isEmpty((String)linejoinString) && StringTools.isEmpty((String)miterlimitString))) {
            float width = StringTools.isEmpty((String)widthString) ? (this.getParentElementHandler() == null || this.getParentElementHandler().getStroke() == null ? (float)this.getRootHandler().toNormalizedHorizontal("1") : this.getParentElementHandler().getStroke().getLineWidth()) : (float)this.getRootHandler().toNormalizedHorizontal(widthString);
            int linecap = STROKE_LINECAP_BUTT.equals(linecapString) ? 0 : ("round".equals(linecapString) ? 1 : (STROKE_LINECAP_SQUARE.equals(linecapString) ? 2 : (this.getParentElementHandler() == null || this.getParentElementHandler().getStroke() == null ? 0 : this.getParentElementHandler().getStroke().getEndCap())));
            int linejoin = STROKE_LINEJOIN_MITER.equals(linecapString) ? 0 : ("round".equals(linecapString) ? 2 : (STROKE_LINEJOIN_BEVEL.equals(linecapString) ? 2 : (this.getParentElementHandler() == null || this.getParentElementHandler().getStroke() == null ? 0 : this.getParentElementHandler().getStroke().getLineJoin())));
            float miterlimit = StringTools.isEmpty((String)miterlimitString) ? (this.getParentElementHandler() == null || this.getParentElementHandler().getStroke() == null ? Math.max(1.0f, width * (float)this.getRootHandler().toNormalizedHorizontal("4")) : this.getParentElementHandler().getStroke().getMiterLimit()) : Math.max(1.0f, width * (float)this.getRootHandler().toNormalizedHorizontal(miterlimitString));
            this.stroke = new BasicStroke(width, linecap, linejoin, miterlimit);
        }
    }
}

