/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image.svg;

import de.intarsys.cwt.image.svg.SvgShapeHandler;
import java.awt.geom.Path2D;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SvgPathHandler
extends SvgShapeHandler {
    private static Logger Log = LoggerFactory.getLogger(SvgPathHandler.class);
    private static final char COMMAND_CLOSEPATH = 'z';
    private static final char COMMAND_CURVETO = 'c';
    private static final char COMMAND_CURVETO_SMOOTH = 's';
    private static final char COMMAND_ELLIPTICAL_ARC = 'a';
    private static final char COMMAND_LINETO = 'l';
    private static final char COMMAND_LINETO_HORIZONTAL = 'h';
    private static final char COMMAND_LINETO_VERTICAL = 'v';
    private static final char COMMAND_MOVETO = 'm';
    private static final char COMMAND_QUADTO = 'q';
    private static final char COMMAND_QUADTO_SMOOTH = 't';
    private static final String PATTERN_COMMA_WSP = "[,\t \n\f\r]";
    private static final String PATTERN_COMMAND = "[MmZzLlHhVvCcSsQqTtAa]";
    private static final String PATTERN_WSP = "[\t \n\f\r]";
    private double currentX = 0.0;
    private double currentY = 0.0;
    private Path2D path = new Path2D.Double();

    @Override
    public void endElement(String pUri, String local, String name) throws SAXException {
        this.setShape(this.path);
        super.endElement(pUri, local, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAttributes(Attributes attrs) throws SAXException {
        super.processAttributes(attrs);
        String data = attrs.getValue("d");
        try (Scanner scanner = new Scanner(data);){
            scanner.useDelimiter(PATTERN_WSP);
            while (scanner.hasNext()) {
                char command = scanner.next().charAt(0);
                switch (Character.toLowerCase(command)) {
                    case 'm': {
                        this.scanMoveToCoordinates(scanner, Character.isLowerCase(command));
                        break;
                    }
                    case 'z': {
                        this.path.closePath();
                        break;
                    }
                    case 'l': {
                        this.scanLineToCoordinates(scanner, Character.isLowerCase(command));
                        break;
                    }
                    case 'h': {
                        this.scanLineToHorizontalCoordinates(scanner, Character.isLowerCase(command));
                        break;
                    }
                    case 'v': {
                        this.scanLineToVerticalCoordinates(scanner, Character.isLowerCase(command));
                        break;
                    }
                    case 'c': {
                        this.scanCurveToCoordinates(scanner, Character.isLowerCase(command));
                        break;
                    }
                    case 's': {
                        Log.warn("skipping not-implemented command smooth curveto");
                        break;
                    }
                    case 'q': {
                        this.scanQuadToCoordinates(scanner, Character.isLowerCase(command));
                        break;
                    }
                    case 't': {
                        Log.warn("skipping not-implemented command smooth quadratic curveto");
                        break;
                    }
                    case 'a': {
                        Log.warn("skipping not-implemented command elliptical arc");
                    }
                }
            }
        }
    }

    protected void scanCurveToCoordinates(Scanner scanner, boolean relative) {
        scanner.useDelimiter(PATTERN_COMMA_WSP);
        do {
            double x1 = this.getRootHandler().toNormalizedHorizontal(scanner.next());
            double y1 = this.getRootHandler().toNormalizedVertical(scanner.next());
            double x2 = this.getRootHandler().toNormalizedHorizontal(scanner.next());
            double y2 = this.getRootHandler().toNormalizedVertical(scanner.next());
            double x = this.getRootHandler().toNormalizedHorizontal(scanner.next());
            double y = this.getRootHandler().toNormalizedVertical(scanner.next());
            if (relative) {
                x1 = this.currentX + x;
                y1 = this.currentY + y;
                x2 = this.currentX + x;
                y2 = this.currentY + y;
                x = this.currentX + x;
                y = this.currentY + y;
            }
            this.path.curveTo(x1, y1, x2, y2, x, y);
            this.currentX = x;
            this.currentY = y;
        } while (scanner.hasNext() && !scanner.hasNext(PATTERN_COMMAND));
        if (scanner.hasNext()) {
            scanner.skip(PATTERN_COMMA_WSP);
            scanner.useDelimiter(PATTERN_WSP);
        }
    }

    protected void scanLineToCoordinates(Scanner scanner, boolean relative) {
        scanner.useDelimiter(PATTERN_COMMA_WSP);
        do {
            double x = this.getRootHandler().toNormalizedHorizontal(scanner.next());
            double y = this.getRootHandler().toNormalizedVertical(scanner.next());
            if (relative) {
                x = this.currentX + x;
                y = this.currentY + y;
            }
            this.path.lineTo(x, y);
            this.currentX = x;
            this.currentY = y;
        } while (scanner.hasNext() && !scanner.hasNext(PATTERN_COMMAND));
        if (scanner.hasNext()) {
            scanner.skip(PATTERN_COMMA_WSP);
            scanner.useDelimiter(PATTERN_WSP);
        }
    }

    protected void scanLineToHorizontalCoordinates(Scanner scanner, boolean relative) {
        scanner.useDelimiter(PATTERN_COMMA_WSP);
        do {
            double x = this.getRootHandler().toNormalizedHorizontal(scanner.next());
            if (relative) {
                x = this.currentX + x;
            }
            this.path.lineTo(x, this.currentY);
            this.currentX = x;
        } while (scanner.hasNext() && !scanner.hasNext(PATTERN_COMMAND));
        if (scanner.hasNext()) {
            scanner.skip(PATTERN_COMMA_WSP);
            scanner.useDelimiter(PATTERN_WSP);
        }
    }

    protected void scanLineToVerticalCoordinates(Scanner scanner, boolean relative) {
        scanner.useDelimiter(PATTERN_COMMA_WSP);
        do {
            double y = this.getRootHandler().toNormalizedVertical(scanner.next());
            if (relative) {
                y = this.currentY + y;
            }
            this.path.lineTo(this.currentX, y);
            this.currentY = y;
        } while (scanner.hasNext() && !scanner.hasNext(PATTERN_COMMAND));
        if (scanner.hasNext()) {
            scanner.skip(PATTERN_COMMA_WSP);
            scanner.useDelimiter(PATTERN_WSP);
        }
    }

    protected void scanMoveToCoordinates(Scanner scanner, boolean relative) {
        scanner.useDelimiter(PATTERN_COMMA_WSP);
        double x = this.getRootHandler().toNormalizedHorizontal(scanner.next());
        double y = this.getRootHandler().toNormalizedVertical(scanner.next());
        if (relative) {
            x = this.currentX + x;
            y = this.currentY + y;
        }
        this.path.moveTo(x, y);
        this.currentX = x;
        this.currentY = y;
        if (scanner.hasNext() && !scanner.hasNext(PATTERN_COMMAND)) {
            this.scanLineToCoordinates(scanner, relative);
        }
        if (scanner.hasNext()) {
            scanner.skip(PATTERN_COMMA_WSP);
            scanner.useDelimiter(PATTERN_WSP);
        }
    }

    protected void scanQuadToCoordinates(Scanner scanner, boolean relative) {
        scanner.useDelimiter(PATTERN_COMMA_WSP);
        do {
            double x1 = this.getRootHandler().toNormalizedHorizontal(scanner.next());
            double y1 = this.getRootHandler().toNormalizedVertical(scanner.next());
            double x = this.getRootHandler().toNormalizedHorizontal(scanner.next());
            double y = this.getRootHandler().toNormalizedVertical(scanner.next());
            if (relative) {
                x1 = this.currentX + x;
                y1 = this.currentY + y;
                x = this.currentX + x;
                y = this.currentY + y;
            }
            this.path.quadTo(x1, y1, x, y);
            this.currentX = x;
            this.currentY = y;
        } while (scanner.hasNext() && !scanner.hasNext(PATTERN_COMMAND));
        if (scanner.hasNext()) {
            scanner.skip(PATTERN_COMMA_WSP);
            scanner.useDelimiter(PATTERN_WSP);
        }
    }
}

