/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image.svg;

import de.intarsys.cwt.image.svg.Svg;
import de.intarsys.cwt.image.svg.SvgDocumentHandler;
import de.intarsys.cwt.image.svg.SvgShapesHandler;
import de.intarsys.tools.sax.ISAXElementHandler;
import de.intarsys.tools.sax.IgnoreElementHandler;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.Point2D;
import java.util.Scanner;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import tec.units.ri.function.MultiplyConverter;
import tec.units.ri.function.RationalConverter;
import tec.units.ri.quantity.NumberQuantity;
import tec.units.ri.quantity.Quantities;
import tec.units.ri.unit.MetricPrefix;
import tec.units.ri.unit.Units;

public class SvgRootHandler
extends SvgShapesHandler {
    private static final String ELEMENT_DESC = "desc";
    private static final String ELEMENT_TITLE = "title";
    public static Unit<Length> UNIT_INCH = MetricPrefix.CENTI((Unit)Units.METRE).transform((UnitConverter)new MultiplyConverter(2.54));
    public static Unit<Length> UNIT_POINT = UNIT_INCH.transform((UnitConverter)new RationalConverter(1.0, 72.0));
    public static Unit<Length> UNIT_PX = UNIT_INCH.transform((UnitConverter)new RationalConverter(1.0, 96.0));
    private double height;
    private Point2D origin;
    private Unit<Length> userUnitHorizontal;
    private Unit<Length> userUnitVertical;
    private double width;

    public static Quantity<?> getQuantity(String string) {
        String tweaked = string.replaceAll("([a-z%]+)", " $1");
        return Quantities.getQuantity((CharSequence)tweaked);
    }

    public void endElement(String pUri, String local, String name) throws SAXException {
        ((SvgDocumentHandler)this.getParent()).setSvg(new Svg(this.getShapes(), this.width, this.height));
    }

    public double getHeight() {
        return this.height;
    }

    @Override
    public SvgRootHandler getParentElementHandler() {
        return null;
    }

    @Override
    public SvgRootHandler getRootHandler() {
        return this;
    }

    public double getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAttributes(Attributes attrs) throws SAXException {
        block10: {
            try {
                Quantity heightQuantity;
                Quantity widthQuantity;
                Quantity<?> declaredWidth = SvgRootHandler.getQuantity(attrs.getValue("width"));
                Quantity<?> declaredHeight = SvgRootHandler.getQuantity(attrs.getValue("height"));
                try {
                    widthQuantity = declaredWidth.asType(Length.class).to(UNIT_POINT);
                }
                catch (ClassCastException ex) {
                    widthQuantity = NumberQuantity.of((double)declaredWidth.getValue().doubleValue(), UNIT_PX).to(UNIT_POINT);
                }
                this.width = widthQuantity.getValue().doubleValue();
                try {
                    heightQuantity = declaredHeight.asType(Length.class).to(UNIT_POINT);
                }
                catch (ClassCastException ex) {
                    heightQuantity = NumberQuantity.of((double)declaredHeight.getValue().doubleValue(), UNIT_PX).to(UNIT_POINT);
                }
                this.height = heightQuantity.getValue().doubleValue();
                String viewBoxString = attrs.getValue("viewBox");
                if (StringTools.isEmpty((String)viewBoxString)) {
                    this.userUnitHorizontal = UNIT_PX;
                    this.userUnitVertical = UNIT_PX;
                    this.origin = new Point2D.Double();
                    break block10;
                }
                try (Scanner scanner = new Scanner(viewBoxString);){
                    double viewBoxX = Double.valueOf(scanner.next());
                    double viewBoxY = Double.valueOf(scanner.next());
                    double viewBoxWidth = Double.valueOf(scanner.next());
                    double viewBoxHeight = Double.valueOf(scanner.next());
                    this.userUnitHorizontal = widthQuantity.getUnit().transform((UnitConverter)new MultiplyConverter(widthQuantity.getValue().doubleValue() / viewBoxWidth));
                    this.userUnitVertical = widthQuantity.getUnit().transform((UnitConverter)new MultiplyConverter(heightQuantity.getValue().doubleValue() / viewBoxHeight));
                    Quantity x = NumberQuantity.of((double)viewBoxX, this.userUnitHorizontal).to(UNIT_POINT);
                    Quantity y = NumberQuantity.of((double)viewBoxY, this.userUnitVertical).to(UNIT_POINT);
                    this.origin = new Point2D.Double(x.getValue().doubleValue(), y.getValue().doubleValue());
                }
            }
            catch (IllegalArgumentException ex) {
                throw new SAXException(ex);
            }
        }
    }

    @Override
    public ISAXElementHandler startElement(String pUri, String local, String name, Attributes attrs) throws SAXException {
        if (name.equals(ELEMENT_DESC)) {
            return new IgnoreElementHandler();
        }
        if (name.equals(ELEMENT_TITLE)) {
            return new IgnoreElementHandler();
        }
        return super.startElement(pUri, local, name, attrs);
    }

    public double toNormalizedHorizontal(String string) {
        Quantity lengthQuantity;
        if (StringTools.isEmpty((String)string)) {
            return 0.0;
        }
        Quantity<?> quantity = SvgRootHandler.getQuantity(string);
        if (quantity.getUnit() == Units.PERCENT) {
            return quantity.multiply((Number)this.width).divide((Number)100).getValue().doubleValue();
        }
        try {
            lengthQuantity = quantity.asType(Length.class).to(this.userUnitHorizontal);
        }
        catch (ClassCastException ex) {
            lengthQuantity = NumberQuantity.of((double)quantity.getValue().doubleValue(), this.userUnitHorizontal);
        }
        return lengthQuantity.to(UNIT_POINT).getValue().doubleValue() - this.origin.getX();
    }

    public double toNormalizedVertical(String string) {
        Quantity lengthQuantity;
        if (StringTools.isEmpty((String)string)) {
            return 0.0;
        }
        Quantity<?> quantity = SvgRootHandler.getQuantity(string);
        if (quantity.getUnit() == Units.PERCENT) {
            return quantity.multiply((Number)this.height).divide((Number)100).getValue().doubleValue();
        }
        try {
            lengthQuantity = quantity.asType(Length.class).to(this.userUnitVertical);
        }
        catch (ClassCastException ex) {
            lengthQuantity = NumberQuantity.of((double)quantity.getValue().doubleValue(), this.userUnitVertical);
        }
        return lengthQuantity.to(UNIT_POINT).getValue().doubleValue() - this.origin.getY();
    }
}

