/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image.svg;

import de.intarsys.cwt.image.svg.SvgElementHandler;
import de.intarsys.cwt.image.svg.SvgGroupHandler;
import de.intarsys.cwt.image.svg.SvgPathHandler;
import de.intarsys.cwt.image.svg.SvgRectHandler;
import de.intarsys.cwt.image.svg.SvgShape;
import de.intarsys.cwt.image.svg.SvgShapes;
import de.intarsys.tools.sax.ISAXElementHandler;
import de.intarsys.tools.sax.IgnoreElementHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SvgShapesHandler
extends SvgElementHandler {
    private static Logger Log = LoggerFactory.getLogger(SvgShapesHandler.class);
    private static final String ELEMENT_G = "g";
    private static final String ELEMENT_PATH = "path";
    private static final String ELEMENT_RECT = "rect";
    private SvgShapes shapes = new SvgShapes();

    public void addShape(SvgShape shape) {
        this.shapes.add(shape);
    }

    public SvgShapes getShapes() {
        return this.shapes;
    }

    public ISAXElementHandler startElement(String pUri, String local, String name, Attributes attrs) throws SAXException {
        if (local.equals(ELEMENT_G)) {
            return new SvgGroupHandler();
        }
        if (local.equals(ELEMENT_PATH)) {
            return new SvgPathHandler();
        }
        if (local.equals(ELEMENT_RECT)) {
            return new SvgRectHandler();
        }
        Log.debug("ignoring unknown element {}", (Object)name);
        return new IgnoreElementHandler();
    }
}

