/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.license.EnumLicenseState;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.ILicenseWithdrawal;
import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicenseProperty;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.license.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.PreferencesFactory;
import java.time.Instant;
import java.util.List;
import java.util.prefs.BackingStoreException;

public final class LicenseAccount
implements ILicenseAccount,
IAttributeSupport {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final LicenseProduct product;
    private final String propertyName;
    private final AttributeMap attributes = new AttributeMap();
    private boolean loaded = false;
    private IPreferences propertyPrefs;
    private String label;
    private LicensePropertyUnit defaultUnit = null;
    private int defaultValue = 0;

    protected LicenseAccount(LicenseProduct product, String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName may not be null");
        }
        this.product = product;
        this.propertyName = propertyName;
    }

    public final Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    @Override
    public int getBalance() {
        LicenseProperty property = this.getLicenseProperty();
        return this.getBalance(property);
    }

    protected int getBalance(LicenseProperty property) {
        LicensePropertyUnit tempUnit = property.getUnit();
        return tempUnit.getBalance(property, this);
    }

    public LicensePropertyUnit getDefaultUnit() {
        return this.defaultUnit;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            String code = "LicenseAccount." + this.getPropertyName() + ".label";
            IMessageBundle bundle = this.getLicenseProduct().getMessageBundle();
            String pattern = bundle.getPattern(code);
            if (pattern == null) {
                return this.getPropertyName();
            }
            return bundle.format(pattern, new Object[0]);
        }
        return this.label;
    }

    @Override
    public LicenseProduct getLicenseProduct() {
        return this.product;
    }

    @Override
    public synchronized LicenseProperty getLicenseProperty() {
        List<License> licenses = this.getLicenseProduct() == LicenseProduct.GLOBAL ? LicenseEnvironment.get().getLicensesAuthorized() : LicenseEnvironment.get().getLicensesAuthorized(this.getLicenseProduct());
        LicenseProperty property = LicenseTools.getLicensePropertyMax(licenses, this.propertyName);
        if (property == null) {
            property = this.getDefaultUnit() != null ? LicenseProperty.create(License.NA, this.propertyName, "" + this.getDefaultValue(), this.getDefaultUnit(), "", false) : LicenseProperty.create(License.NA, this.propertyName, "0", LicensePropertyUnit.DEFAULT, "", false);
        }
        return property;
    }

    @Override
    public EnumLicenseState getLicenseState() {
        LicenseProperty property = this.getLicenseProperty();
        LicenseProduct product = LicenseEnvironment.get().lookupProduct(property.getLicense().getProductId());
        return property.getLicense().getState(product);
    }

    @Override
    public int getLimit() {
        LicenseProperty property = this.getLicenseProperty();
        return this.getLimit(property);
    }

    protected int getLimit(LicenseProperty property) {
        LicensePropertyUnit tempUnit = property.getUnit();
        return tempUnit.getLimit(property, this);
    }

    @Override
    public String getName() {
        return this.getPropertyName();
    }

    @Override
    public Instant getNextReset() {
        LicenseProperty property = this.getLicenseProperty();
        return this.getNextReset(property);
    }

    protected Instant getNextReset(LicenseProperty property) {
        return property.getUnit().getNextReset(this);
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    protected IPreferences getPropertyPreferences() {
        if (this.propertyPrefs == null) {
            IPreferences preferences = PreferencesFactory.get().getMain();
            IPreferences licenseNode = preferences.node(this.getLicenseProduct().getId());
            this.propertyPrefs = licenseNode.node(this.getPropertyName());
        }
        return this.propertyPrefs;
    }

    protected String getWithdrawMessage(int amount) {
        return Msg.getString("LicenseAccount.Withdraw", new Object[]{this.getLicenseProduct().getId(), this.getPropertyName(), amount});
    }

    @Override
    public boolean isDefined() {
        return this.getLicenseProperty().isDefined();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(LicensePropertyUnit unit) {
        LicenseAccount licenseAccount = this;
        synchronized (licenseAccount) {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            unit.load(this, this.getPropertyPreferences());
        }
    }

    public final Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    @Override
    public ILicenseWithdrawal reserve(int amount) throws LicenseException {
        LicenseProperty property = this.getLicenseProperty();
        LicensePropertyUnit tempUnit = property.getUnit();
        return tempUnit.reserve(this, property, amount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(LicensePropertyUnit unit) {
        LicenseAccount licenseAccount = this;
        synchronized (licenseAccount) {
            long lastSave = LicensePropertyUnit.getLastSave(this);
            long current = System.currentTimeMillis();
            if (current - lastSave > 60000L) {
                LicensePropertyUnit.setLastSave(this, current);
                unit.save(this, this.getPropertyPreferences());
                try {
                    this.getPropertyPreferences().flush();
                }
                catch (BackingStoreException backingStoreException) {}
            } else {
                unit.save(this, this.getPropertyPreferences());
            }
        }
    }

    public final Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setDefaultUnit(LicensePropertyUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("unit can not be null");
        }
        if (this.defaultUnit != null && this.defaultUnit != unit) {
            throw new LicenseException("license tampering");
        }
        this.defaultUnit = unit;
    }

    public void setDefaultValue(int value) {
        if (this.defaultValue != 0 && this.defaultValue != value) {
            throw new LicenseException("license tampering");
        }
        this.defaultValue = value;
    }

    @Override
    public void setDefaultValueUnit(int value, LicensePropertyUnit unit) {
        this.setDefaultValue(value);
        this.setDefaultUnit(unit);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return "license account on " + this.getName();
    }
}

