/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.eclipselink;

import de.intarsys.spring.eclipselink.EclipseLinkJpaProperties;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.orm.jpa.JpaBaseConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaVendorAdapter;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.ClassUtils;

@Configuration
@EnableConfigurationProperties(value={EclipseLinkJpaProperties.class})
public class EclipseLinkJpaConfiguration
extends JpaBaseConfiguration {
    private static final String SLF4J_LOGGER_CLASSNAME = "org.eclipse.persistence.logging.slf4j.SLF4JLogger";
    private EclipseLinkJpaProperties properties;

    public EclipseLinkJpaConfiguration(DataSource dataSource, JpaProperties jpaProperties, ObjectProvider<JtaTransactionManager> jtaTransactionManager, EclipseLinkJpaProperties properties) {
        super(dataSource, jpaProperties, jtaTransactionManager);
        this.properties = properties;
    }

    protected EclipseLinkJpaVendorAdapter createJpaVendorAdapter() {
        return new EclipseLinkJpaVendorAdapter();
    }

    protected Map<String, Object> getVendorProperties() {
        HashMap<String, Object> vendorProperties = new HashMap<String, Object>();
        vendorProperties.put("eclipselink.weaving", "false");
        vendorProperties.put("eclipselink.persistence-context.flush-mode", "COMMIT");
        return vendorProperties;
    }

    protected void customizeVendorProperties(Map<String, Object> vendorProperties) {
        String logger;
        if (!this.properties.isSharedCacheEnabled()) {
            vendorProperties.put("eclipselink.cache.shared.default", "false");
        }
        if ((logger = this.properties.getLogger()) == null) {
            logger = ClassUtils.isPresent((String)SLF4J_LOGGER_CLASSNAME, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()) ? SLF4J_LOGGER_CLASSNAME : "JavaLogger";
        }
        vendorProperties.put("eclipselink.logging.logger", logger);
    }
}

