/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.element;

import de.intarsys.layout.CAlignment;
import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.LayoutPrimitive;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.layout.element.PDLElement;
import de.intarsys.pdf.layout.html.parser.CSSPosition;
import de.intarsys.pdf.layout.parser.PDLParseException;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDXObject;
import de.intarsys.pdf.platform.cwt.image.awt.ImageConverterAwt2Pdf;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.enumeration.common.EnumScaleWhen;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class PDLBackgroundImage
extends PDLElement {
    private BufferedImage image;
    private Rectangle2D bounds;
    private EnumRepeat repeat;
    private EnumScaleWhen scale;
    private EnumScaleMode scaleMode;
    private CSSPosition position;

    @Override
    protected ILayoutComponent createComponent() {
        return new LayoutPrimitive(0.0f, 0.0f);
    }

    protected CDSMatrix fit(ICSDevice device) {
        float destWidth = (float)this.getBounds().getWidth();
        float destHeight = (float)this.getBounds().getHeight();
        float imageWidth = this.getImage().getWidth();
        float imageHeight = this.getImage().getHeight();
        float scaleX = destWidth / imageWidth;
        float scaleY = destHeight / imageHeight;
        if (this.isScaleProportional()) {
            scaleY = scaleX = Math.min(scaleX, scaleY);
        }
        if (this.getScale() != EnumScaleWhen.ALWAYS) {
            if (this.getScale() == EnumScaleWhen.NEVER) {
                scaleX = 1.0f;
                scaleY = 1.0f;
            } else if (this.getScale() == EnumScaleWhen.TOOBIG) {
                if (scaleX > 1.0f && scaleY > 1.0f) {
                    scaleX = 1.0f;
                    scaleY = 1.0f;
                }
            } else if (this.getScale() == EnumScaleWhen.TOOSMALL && scaleX <= 1.0f && scaleY <= 1.0f) {
                scaleX = 1.0f;
                scaleY = 1.0f;
            }
        }
        float scaledWidth = imageWidth * scaleX;
        float scaledHeight = imageHeight * scaleY;
        float alignX = 0.0f;
        if (this.getPosition().getHor() == CAlignment.CENTER) {
            alignX = 0.5f;
        } else if (this.getPosition().getHor() == CAlignment.RIGHT) {
            alignX = 1.0f;
        }
        float alignY = 1.0f;
        if (this.getPosition().getVer() == CAlignment.CENTER) {
            alignY = 0.5f;
        } else if (this.getPosition().getHor() == CAlignment.BOTTOM) {
            alignY = 0.0f;
        }
        double offsetX = Math.max(0.0f, destWidth - scaledWidth) * alignX;
        double offsetY = Math.max(0.0f, destHeight - scaledHeight) * alignY;
        CDSMatrix matrix = new CDSMatrix();
        matrix.translate((float)this.getBounds().getMinX(), (float)this.getBounds().getMinY());
        matrix.translate((float)offsetX, (float)offsetY);
        matrix.scale(new float[]{scaledWidth, scaledHeight});
        return matrix;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    protected BufferedImage getImage(float width, float height) {
        BufferedImage fullImage = this.getImage();
        if (height >= (float)fullImage.getHeight() && width >= (float)fullImage.getWidth()) {
            return fullImage;
        }
        width = Math.min((float)fullImage.getWidth(), width);
        height = Math.min((float)fullImage.getHeight(), height);
        BufferedImage newImage = new BufferedImage((int)width, (int)height, 1);
        Graphics2D graphics = newImage.createGraphics();
        graphics.setClip(0, 0, (int)width, (int)height);
        graphics.drawImage((Image)fullImage, 0, 0, null);
        graphics.dispose();
        return newImage;
    }

    protected PDImage getPDImage(Map<Point2D, PDImage> images, Point2D size) {
        PDImage pdImage = images.get(size);
        if (pdImage == null) {
            ImageConverterAwt2Pdf converter = new ImageConverterAwt2Pdf(this.getImage((float)size.getX(), (float)size.getY()));
            converter.setPreferJpeg(true);
            pdImage = converter.getPDImage();
            images.put(size, pdImage);
        }
        return pdImage;
    }

    public CSSPosition getPosition() {
        if (this.position == null) {
            this.position = new CSSPosition(null);
        }
        return this.position;
    }

    public EnumRepeat getRepeat() {
        if (this.repeat == null) {
            this.repeat = (EnumRepeat)EnumRepeat.META.getDefault();
        }
        return this.repeat;
    }

    public EnumScaleWhen getScale() {
        if (this.scale == null) {
            this.scale = (EnumScaleWhen)EnumScaleWhen.META.getDefault();
        }
        return this.scale;
    }

    public EnumScaleMode getScaleMode() {
        return this.scaleMode;
    }

    @Override
    public boolean isControlElement() {
        return false;
    }

    protected boolean isScaleProportional() {
        return this.getScaleMode() == EnumScaleMode.PROPORTIONAL;
    }

    @Override
    public boolean isTextElement() {
        return false;
    }

    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    private void setImage(BufferedImage image) {
        this.image = image;
    }

    public void setPosition(CSSPosition position) {
        this.position = position;
    }

    public void setRepeat(EnumRepeat repeat) {
        this.repeat = repeat;
    }

    public void setScale(EnumScaleWhen scale) {
        this.scale = scale;
    }

    public void setScaleMode(EnumScaleMode scaleMode) {
        this.scaleMode = scaleMode;
    }

    public void setSource(ILocator source) throws PDLParseException {
        if (!source.exists()) {
            throw new PDLParseException("source path for image doesn't exist (src=" + source.getPath() + ")");
        }
        InputStream is = null;
        try {
            is = source.getInputStream();
            this.setImage(ImageIO.read(is));
        }
        catch (IOException e) {
            throw new PDLParseException(e);
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }

    @Override
    public void writeOn(ICSDevice device) {
        if (this.getRepeat() == EnumRepeat.NO_REPEAT) {
            this.writeSingleOn(device);
        } else if (this.getRepeat() == EnumRepeat.REPEAT) {
            this.writeOn(device, true, true);
        } else if (this.getRepeat() == EnumRepeat.REPEAT_X) {
            this.writeOn(device, true, false);
        } else if (this.getRepeat() == EnumRepeat.REPEAT_Y) {
            this.writeOn(device, false, true);
        }
    }

    protected void writeOn(ICSDevice device, boolean repeatX, boolean repeatY) {
        float width = this.getImage().getWidth();
        float height = this.getImage().getHeight();
        float offsetX = (float)this.getBounds().getX();
        float offsetY = (float)this.getBounds().getY();
        int xCount = 1;
        if (repeatX) {
            xCount = (int)Math.ceil(this.getBounds().getWidth() / (double)width);
        } else if ((double)width < this.getBounds().getWidth()) {
            offsetX += (float)(this.getBounds().getWidth() - (double)width) / 2.0f;
        }
        int yCount = 1;
        if (repeatY) {
            yCount = (int)Math.ceil(this.getBounds().getHeight() / (double)height);
            offsetY = (float)this.getBounds().getMaxY() - (float)yCount * height;
        } else if ((double)height < this.getBounds().getHeight()) {
            offsetY += (float)(this.getBounds().getHeight() - (double)height) / 2.0f;
        }
        HashMap<Point2D, PDImage> images = new HashMap<Point2D, PDImage>();
        for (int i = 0; i < xCount; ++i) {
            for (int j = 0; j < yCount; ++j) {
                device.saveState();
                float x = offsetX + (float)i * width;
                float y = offsetY + (float)j * height;
                float localWidth = (float)this.getBounds().getMaxX() - x;
                float localHeight = height;
                if ((double)x < this.getBounds().getX()) {
                    x = (float)this.getBounds().getX();
                    float exceedX = (float)xCount * height - (float)this.getBounds().getWidth();
                    if (exceedX > 0.0f) {
                        localWidth -= exceedX;
                    }
                }
                localWidth = (float)Math.min((double)localWidth, this.getBounds().getWidth());
                if ((double)y < this.getBounds().getY()) {
                    y = (float)this.getBounds().getY();
                    float exceedY = (float)yCount * height - (float)this.getBounds().getHeight();
                    if (exceedY > 0.0f) {
                        localHeight -= exceedY;
                    }
                }
                localHeight = (float)Math.min((double)localHeight, this.getBounds().getHeight());
                PDImage pdImage = this.getPDImage(images, new Point2D.Float(localWidth, localHeight));
                device.transform((float)pdImage.getWidth(), 0.0f, 0.0f, (float)pdImage.getHeight(), x, y);
                device.doXObject(null, (PDXObject)pdImage);
                device.restoreState();
            }
        }
    }

    protected void writeSingleOn(ICSDevice device) {
        device.saveState();
        CDSMatrix matrix = this.fit(device);
        ImageConverterAwt2Pdf converter = new ImageConverterAwt2Pdf(this.getImage());
        converter.setPreferJpeg(true);
        PDImage pdImage = converter.getPDImage();
        device.transform(matrix.getA(), matrix.getB(), matrix.getC(), matrix.getD(), matrix.getE(), matrix.getF());
        device.doXObject(null, (PDXObject)pdImage);
        device.restoreState();
    }

    public static class EnumRepeat
    extends EnumItem {
        public static final EnumMeta META = EnumRepeat.getMeta(EnumRepeat.class);
        public static final EnumRepeat REPEAT = new EnumRepeat("repeat");
        public static final EnumRepeat REPEAT_X = new EnumRepeat("repeat-x");
        public static final EnumRepeat REPEAT_Y = new EnumRepeat("repeat-y");
        public static final EnumRepeat NO_REPEAT = new EnumRepeat("no-repeat");

        public EnumRepeat(String id) {
            super(id);
        }

        static {
            REPEAT.setDefault();
        }
    }

    public static class EnumScaleMode
    extends EnumItem {
        public static final EnumMeta META = EnumScaleMode.getMeta(EnumScaleMode.class);
        public static final EnumScaleMode PROPORTIONAL = new EnumScaleMode("proportional");
        public static final EnumScaleMode ANAMORPHIC = new EnumScaleMode("anamorphic");

        public EnumScaleMode(String id) {
            super(id);
        }

        static {
            ANAMORPHIC.setDefault();
        }
    }
}

