/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.element;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.ILayoutVisitor;
import de.intarsys.pdf.content.ICSDevice;
import java.awt.geom.Rectangle2D;
import java.util.List;

public abstract class PDLElement
implements ILayoutComponent {
    private ILayoutComponent component = this.createComponent();

    public Object accept(ILayoutVisitor visitor) {
        return visitor.visitFromLayoutComponent((ILayoutComponent)this);
    }

    protected abstract ILayoutComponent createComponent();

    public float getAscent() {
        return 0.0f;
    }

    public Rectangle2D getBoundingBox() {
        return new Rectangle2D.Float(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
    }

    public ILayoutComponent getComponent() {
        return this.component;
    }

    public float getDescent() {
        return 0.0f;
    }

    public float getHeight() {
        return this.component.getHeight();
    }

    protected float getLocalVerticalSpace() {
        return 0.0f;
    }

    public float getMaxX() {
        return this.getMinX() + this.getWidth();
    }

    public float getMaxY() {
        return this.getMinY() + this.getHeight();
    }

    public float getMinX() {
        return this.component.getMinX();
    }

    public float getMinY() {
        return this.component.getMinY();
    }

    public float getWidth() {
        return this.component.getWidth();
    }

    public abstract boolean isControlElement();

    public boolean isForced() {
        return false;
    }

    public abstract boolean isTextElement();

    public void move(float dx, float dy) {
        this.component.move(dx, dy);
    }

    public void moveTo(float x, float y) {
        this.component.moveTo(x, y);
    }

    public void resetLayout() {
        this.component.resetLayout();
    }

    protected void setComponent(ILayoutComponent component) {
        this.component = component;
    }

    public void setHeight(float height) {
        this.component.setHeight(height);
    }

    public void setWidth(float width) {
        this.component.setWidth(width);
    }

    public List splitHorizontal(float max) {
        return null;
    }

    public List splitVertical(float max, boolean reverse) {
        return this.component.splitVertical(max - this.getLocalVerticalSpace(), reverse);
    }

    public void trim() {
    }

    public void writeOn(ICSDevice device) {
    }
}

