/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.element;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.LayoutPrimitive;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.layout.element.PDLElement;
import de.intarsys.pdf.layout.parser.PDLParseException;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDXObject;
import de.intarsys.pdf.platform.cwt.image.awt.ImageConverterAwt2Pdf;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class PDLImage
extends PDLElement {
    private BufferedImage image;

    @Override
    protected ILayoutComponent createComponent() {
        return new LayoutPrimitive(0.0f, 0.0f);
    }

    private float defToAbsolute(String def, float originalValue) {
        if (def == null) {
            return originalValue;
        }
        if ((def = def.trim()).endsWith("%")) {
            float percent = Float.parseFloat(def.substring(0, def.length() - 1));
            return originalValue * percent / 100.0f;
        }
        return Float.parseFloat(def);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public boolean isControlElement() {
        return false;
    }

    @Override
    public boolean isTextElement() {
        return false;
    }

    public void setHeightDef(String height) {
        this.setHeight(this.defToAbsolute(height, this.getHeight()));
    }

    private void setImage(BufferedImage image) {
        this.image = image;
    }

    public void setSource(ILocator source) throws PDLParseException {
        if (!source.exists()) {
            throw new PDLParseException("source path for image doesn't exist (src=" + source.getPath() + ")");
        }
        InputStream is = null;
        try {
            is = source.getInputStream();
            this.setImage(ImageIO.read(is));
        }
        catch (IOException e) {
            throw new PDLParseException(e);
        }
        finally {
            StreamTools.close((Closeable)is);
        }
        this.setWidth(this.getImage().getWidth());
        this.setHeight(this.getImage().getHeight());
    }

    public void setWidthDef(String width) {
        this.setWidth(this.defToAbsolute(width, this.getWidth()));
    }

    @Override
    public void writeOn(ICSDevice device) {
        ImageConverterAwt2Pdf converter = new ImageConverterAwt2Pdf(this.getImage());
        converter.setPreferJpeg(true);
        PDImage pdImage = converter.getPDImage();
        device.saveState();
        device.transform(this.getWidth(), 0.0f, 0.0f, this.getHeight(), this.getMinX(), this.getMinY());
        device.doXObject(null, (PDXObject)pdImage);
        device.restoreState();
    }
}

