/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.element;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.pdf.layout.element.PDLCR;
import de.intarsys.pdf.layout.element.PDLFF;
import de.intarsys.pdf.layout.element.PDLLF;
import de.intarsys.pdf.layout.element.PDLTextElement;
import de.intarsys.pdf.layout.pad.PDLParagraphFormat;
import de.intarsys.pdf.layout.pad.PDLTabSet;
import de.intarsys.pdf.layout.pad.PDLTabStop;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import java.util.ArrayList;
import java.util.List;

public class PDLTab
extends PDLTextElement {
    public static float DEFAULT_TABWIDTH = 72.0f;
    private ILayoutComponent previousElement = null;
    private List trailElements = new ArrayList();
    private PDLTabStop tabStop;
    private float offset = 0.0f;
    private float trailWidth = 0.0f;
    private PDLParagraphFormat paragraphFormat;

    protected PDLTab(PDLTextFormat state, PDLParagraphFormat paragraphFormat, int direction) {
        super(state, new char[]{'\t'}, 0, 1, direction);
        this.paragraphFormat = paragraphFormat;
    }

    public boolean addTrailElement(ILayoutComponent component) {
        if (this.getTabStop().isLeftAligned()) {
            return false;
        }
        if (component instanceof PDLTab || component instanceof PDLCR || component instanceof PDLLF || component instanceof PDLFF) {
            return false;
        }
        if (this.computeWidth() < 0.0f) {
            return false;
        }
        this.trailElements.add(component);
        this.trailWidth += component.getWidth();
        return true;
    }

    protected float computeWidth() {
        float result = 0.0f;
        float startPos = this.getStartPos();
        PDLTabStop currentTabStop = this.getTabStop();
        if (currentTabStop.isLeftAligned()) {
            result = currentTabStop.getPosition() - startPos + this.getOffset();
        } else if (currentTabStop.isCenterAligned()) {
            result = currentTabStop.getPosition() - startPos + this.getOffset() - this.getTrailWidth() / 2.0f;
        } else if (currentTabStop.isRightAligned()) {
            result = currentTabStop.getPosition() - startPos + this.getOffset() - this.getTrailWidth();
        }
        return result;
    }

    public float getOffset() {
        return this.offset;
    }

    protected PDLParagraphFormat getParagraphFormat() {
        return this.paragraphFormat;
    }

    public ILayoutComponent getPreviousElement() {
        return this.previousElement;
    }

    protected float getStartPos() {
        return this.getPreviousElement() == null ? 0.0f : this.getPreviousElement().getMaxX();
    }

    protected PDLTabStop getTabStop() {
        if (this.tabStop == null) {
            PDLTabSet set = this.getParagraphFormat().getTabSet();
            if (set != null) {
                this.tabStop = set.findNext(this.getStartPos() - this.getOffset());
            }
            if (this.tabStop == null) {
                float pos;
                for (pos = this.getOffset(); pos <= this.getStartPos(); pos += DEFAULT_TABWIDTH) {
                }
                this.tabStop = new PDLTabStop(pos - this.getOffset());
            }
        }
        return this.tabStop;
    }

    public List getTrailElements() {
        return this.trailElements;
    }

    protected float getTrailWidth() {
        return this.trailWidth;
    }

    @Override
    public float getWidth() {
        if (super.getWidth() == 0.0f) {
            float result = this.computeWidth();
            if (result <= 0.0f) {
                result = this.getTextFormat().getRenderingWidth(new byte[]{32}, 0, 1);
            }
            this.setWidth(result);
        }
        return super.getWidth();
    }

    @Override
    public void resetLayout() {
        super.resetLayout();
        this.offset = 0.0f;
        this.previousElement = null;
        this.trailElements.clear();
        this.trailWidth = 0.0f;
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }

    public void setPreviousElement(ILayoutComponent component) {
        this.previousElement = component;
    }
}

