/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.element;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.LayoutPrimitive;
import de.intarsys.pdf.layout.element.PDLCR;
import de.intarsys.pdf.layout.element.PDLElement;
import de.intarsys.pdf.layout.element.PDLFF;
import de.intarsys.pdf.layout.element.PDLLF;
import de.intarsys.pdf.layout.element.PDLTab;
import de.intarsys.pdf.layout.element.PDLTextRun;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLTextFormat;

public abstract class PDLTextElement
extends PDLElement {
    private int direction = 0;
    private final PDLTextFormat textFormat;
    private char[] text;

    public static PDLTextElement createTextElement(IPDLTextPad pad, char[] newText, int newOff, int newLen, int direction) {
        if (newText == null) {
            throw new NullPointerException("text may not be null");
        }
        if (newLen == 1) {
            if (newText[0] == '\t') {
                return new PDLTab(pad.getTextFormat(), pad.getParagraphFormat(), direction);
            }
            if (newText[0] == '\n') {
                return new PDLLF(pad.getTextFormat(), true);
            }
            if (newText[0] == '\r') {
                return new PDLCR(pad.getTextFormat());
            }
            if (newText[0] == '\f') {
                return new PDLFF(pad.getTextFormat());
            }
        }
        return new PDLTextRun(pad.getTextFormat(), newText, newOff, newLen, direction);
    }

    protected PDLTextElement(PDLTextFormat textFormat, char[] newText, int newOff, int newLen, int direction) {
        this.textFormat = textFormat;
        this.text = new char[newLen];
        System.arraycopy(newText, newOff, this.text, 0, newLen);
        this.setHeight(this.getTextFormat().getScaledFontHeight());
        this.direction = direction;
    }

    @Override
    protected ILayoutComponent createComponent() {
        return new LayoutPrimitive(0.0f, 0.0f);
    }

    @Override
    public float getAscent() {
        return this.getTextFormat().getScaledFontAscent();
    }

    @Override
    public float getDescent() {
        return this.getTextFormat().getScaledFontDescent();
    }

    public int getDirection() {
        return this.direction;
    }

    public char[] getText() {
        return this.text;
    }

    public PDLTextFormat getTextFormat() {
        return this.textFormat;
    }

    @Override
    public boolean isControlElement() {
        return false;
    }

    @Override
    public boolean isTextElement() {
        return true;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int size() {
        return this.text.length;
    }

    public String toString() {
        return new String(this.text);
    }
}

