/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.element;

import de.intarsys.layout.CDirection;
import de.intarsys.layout.ITrimmableComponent;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.common.CSDeviceTools;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.font.CIDFont;
import de.intarsys.pdf.font.CIDFontType2;
import de.intarsys.pdf.font.CIDWidthMap;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontType0;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.layout.element.PDLTextElement;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.PlatformFontFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PDLTextRun
extends PDLTextElement
implements ITrimmableComponent {
    private byte[] preparedText;

    protected PDLTextRun(PDLTextFormat state, char[] newText, int newOff, int newLen, int direction) {
        super(state, newText, newOff, newLen, direction);
    }

    protected byte[] getPreparedText() {
        if (this.preparedText == null) {
            this.preparedText = this.prepare(this.getText());
        }
        return this.preparedText;
    }

    @Override
    public float getWidth() {
        if (super.getWidth() == 0.0f) {
            byte[] text = this.getPreparedText();
            this.setWidth(this.getTextFormat().getRenderingWidth(text, 0, text.length));
        }
        return super.getWidth();
    }

    public boolean isTrimmable() {
        for (int i = 0; i < this.getText().length; ++i) {
            if (this.getText()[i] <= ' ') continue;
            return false;
        }
        return true;
    }

    protected byte[] prepare(char[] tempText) {
        for (int i = 0; i < tempText.length; ++i) {
            if (tempText[i] != '\u00a0') continue;
            tempText[i] = 32;
        }
        PDFont preparedFont = this.getTextFormat().getFont();
        if (preparedFont instanceof PDFontType0) {
            PDFontType0 pdFontType0 = (PDFontType0)preparedFont;
            CIDFont cidFont = pdFontType0.getDescendantFont();
            char[] tempTempText = new char[tempText.length];
            if (cidFont instanceof CIDFontType2) {
                try {
                    IPlatformFont pfFont = PlatformFontFactory.get().createPlatformFont(preparedFont);
                    for (int i = 0; i < tempText.length; ++i) {
                        int index = pfFont.getCharIndex(tempText[i]);
                        tempTempText[i] = (char)index;
                        PDGlyphs pdGlyphs = preparedFont.getGlyphsEncoded(index);
                        IPlatformGlyphs pfGlyphs = pfFont.createPlatformGlyphs(pdGlyphs);
                        int width = pfGlyphs.getWidth();
                        CIDWidthMap map = cidFont.getCIDWidthMap();
                        if (map == null) {
                            map = (CIDWidthMap)CIDWidthMap.META.createNew();
                            cidFont.setCIDWidthMap(map);
                        }
                        if (map.getWidth(index) != -1) continue;
                        map.addWidth(index, width);
                        pdGlyphs.reset();
                    }
                }
                catch (PlatformFontException platformFontException) {
                    // empty catch block
                }
            }
            tempText = tempTempText;
        }
        if (CDirection.isAscending((int)this.getDirection())) {
            return preparedFont.getEncoding().encode(tempText, 0, tempText.length);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Encoding encoding = preparedFont.getEncoding();
        for (int i = tempText.length - 1; i >= 0; --i) {
            encoding.encode((OutputStream)bos, tempText, i, 1);
        }
        return bos.toByteArray();
    }

    @Override
    public List splitHorizontal(float max) {
        char[] text = this.getText();
        int lastChar = -1;
        int i = 0;
        while (i < text.length) {
            char[] subText = new char[i + 1];
            System.arraycopy(text, 0, subText, 0, i + 1);
            byte[] preparedSubText = this.prepare(subText);
            float subTextWidth = this.getTextFormat().getRenderingWidth(preparedSubText, 0, preparedSubText.length);
            if (subTextWidth > max) break;
            lastChar = i++;
        }
        if (lastChar == -1 || lastChar + 1 == text.length) {
            return null;
        }
        ArrayList<PDLTextRun> result = new ArrayList<PDLTextRun>();
        PDLTextRun part = new PDLTextRun(this.getTextFormat(), text, 0, lastChar + 1, this.getDirection());
        result.add(part);
        part = new PDLTextRun(this.getTextFormat(), text, lastChar + 1, text.length - (lastChar + 1), this.getDirection());
        result.add(part);
        return result;
    }

    @Override
    public void writeOn(ICSDevice device) {
        float[] color = this.getTextFormat().getColor();
        if (color != null) {
            CSDeviceTools.setNonStrokeColor((ICSDevice)device, (float[])color);
        } else {
            device.setNonStrokeColorRGB(0.0f, 0.0f, 0.0f);
        }
        float fontSize = this.getTextFormat().getFontSize();
        device.textSetFont(null, this.getTextFormat().getFont(), fontSize);
        float y = this.getMinY() + this.getTextFormat().getMoveY();
        float offX = this.getMinX();
        this.preparedText = this.prepare(this.getText());
        int length = this.preparedText.length;
        if (this.getTextFormat().isFixedWidth()) {
            float fixedWidth = this.getTextFormat().getFixedWidth();
            for (int i = 0; i < length; ++i) {
                float glyphWidth = this.getTextFormat().getGlyphWidthEncoded(this.preparedText, i, 1);
                device.textMoveTo(offX + (fixedWidth - glyphWidth) / 2.0f, y);
                device.textShow(this.preparedText, i, 1);
                offX += fixedWidth;
            }
        } else {
            device.textMoveTo(offX, y);
            device.textShow(this.preparedText, 0, length);
        }
        if (this.getTextFormat().isUnderline()) {
            int underlinePosition = -100;
            int underlineThickness = 10;
            try {
                IPlatformFont pfFont = PlatformFontFactory.get().createPlatformFont(this.getTextFormat().getFont());
                underlinePosition = pfFont.getUnderlinePosition();
                underlineThickness = pfFont.getUnderlineThickness();
            }
            catch (PlatformFontException pfFont) {
                // empty catch block
            }
            float uPos = this.getMinY() + (float)(underlinePosition / 1000) * fontSize;
            float lineWidth = (float)underlineThickness / 1000.0f * this.getTextFormat().getFontSize();
            device.setLineWidth(lineWidth);
            device.penMoveTo(this.getMinX(), uPos);
            device.penLineTo(this.getMinX() + this.getWidth(), uPos);
            device.pathStroke();
        }
        if (this.getTextFormat().isStrike()) {
            int underlineThickness = 10;
            try {
                IPlatformFont pfFont = PlatformFontFactory.get().createPlatformFont(this.getTextFormat().getFont());
                underlineThickness = pfFont.getUnderlineThickness();
            }
            catch (PlatformFontException pfFont) {
                // empty catch block
            }
            float sPos = this.getMinY() + this.getTextFormat().getFontSize() / 3.0f;
            float lineWidth = (float)underlineThickness / 1000.0f * this.getTextFormat().getFontSize();
            device.setLineWidth(lineWidth);
            device.penMoveTo(this.getMinX(), sPos);
            device.penLineTo(this.getMinX() + this.getWidth(), sPos);
            device.pathStroke();
        }
    }
}

