/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.annotation;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.ILayoutContainer;
import de.intarsys.layout.ILayoutVisitor;
import de.intarsys.layout.LayoutContainer;
import de.intarsys.pdf.app.annotation.AnnotationOutlet;
import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.layout.html.annotation.PDLLinkEnd;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDActionGoTo;
import de.intarsys.pdf.pd.PDActionURI;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDLinkAnnotation;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkAnnotationCreator
implements ILayoutVisitor {
    private static final Logger Log = LoggerFactory.getLogger(LinkAnnotationCreator.class);
    private PDLLinkEnd end;
    private boolean include = false;
    private LayoutContainer myContainer = new LayoutContainer();

    public LinkAnnotationCreator(PDLLinkEnd end) {
        this.end = end;
    }

    protected PDAction createAction() {
        if (this.end.getHref().startsWith("#")) {
            PDActionGoTo action = (PDActionGoTo)PDActionGoTo.META.createNew();
            String name = this.end.getHref().substring(1);
            COSName cosName = COSName.createUTF8((String)name);
            action.cosSetField(PDActionGoTo.DK_D, (COSObject)cosName);
            return action;
        }
        PDActionURI action = (PDActionURI)PDActionURI.META.createNew();
        action.setURI(this.end.getHref());
        return action;
    }

    protected void createAnnotation() {
        CDSRectangle rect = new CDSRectangle(this.myContainer.getMinX(), this.myContainer.getMinY() - 3.0f, this.myContainer.getMaxX(), this.myContainer.getMaxY() - 3.0f);
        PDAnnotation annot = null;
        try {
            annot = this.getAnnotationFactory().createAnnotation(this.end.getPage(), rect.toRectangle(), Collections.EMPTY_MAP);
        }
        catch (ObjectCreationException e) {
            Log.warn("Unable to create link annotation.", (Throwable)e);
            return;
        }
        annot.setRectangle(rect);
        PDAction action = this.createAction();
        if (action != null) {
            annot.addAction(action);
        }
    }

    protected void flush() {
        if (this.hasContent()) {
            this.createAnnotation();
        }
        this.myContainer = new LayoutContainer();
    }

    protected IAnnotationFactory getAnnotationFactory() {
        return AnnotationOutlet.get().lookupAnnotationFactory(PDLinkAnnotation.CN_Subtype_Link);
    }

    protected float getFontSize(PDLTextFormat tf) {
        float descent = tf.getFont().getFontDescriptor().getDescent();
        descent = descent * tf.getFontSize() / 1000.0f;
        descent = Math.abs(descent);
        return descent;
    }

    protected boolean hasContent() {
        return this.myContainer.getWidth() > 0.0f && this.myContainer.getHeight() > 0.0f;
    }

    protected void include(ILayoutComponent component) {
        if (this.hasContent() && component.getMinX() < this.myContainer.getMinX()) {
            this.flush();
        }
        this.myContainer.add(component);
    }

    protected void include(ILayoutContainer container) {
        this.myContainer.add((ILayoutComponent)container);
    }

    public Object visitFromLayoutComponent(ILayoutComponent component) {
        if (component == this.end.getStart()) {
            this.include = true;
            return Boolean.TRUE;
        }
        if (component == this.end) {
            this.include = false;
            this.flush();
            return Boolean.FALSE;
        }
        if (this.include) {
            this.include(component);
        }
        return Boolean.TRUE;
    }

    public Object visitFromLayoutContainer(ILayoutContainer container) {
        ILayoutComponent child;
        Boolean result = Boolean.TRUE;
        ILayoutComponent[] children = container.children();
        for (int i = 0; i < children.length && (result = (Boolean)(child = children[i]).accept((ILayoutVisitor)this)).booleanValue(); ++i) {
        }
        this.flush();
        return result;
    }
}

