/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.annotation;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.LayoutPrimitive;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.layout.element.PDLElement;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDExplicitDestination;
import de.intarsys.pdf.pd.PDPage;

public class PDLAnchor
extends PDLElement {
    private PDPage page;
    private String name;

    public PDLAnchor(PDPage page, String name) {
        this.page = page;
        this.name = name;
    }

    protected void addNamedDestination() {
        if (this.page == null || this.name == null) {
            return;
        }
        PDDocument doc = this.page.getDoc();
        COSCatalog catalog = doc.getCatalog();
        COSDictionary destsDict = catalog.cosGetDests();
        if (destsDict == null) {
            destsDict = COSDictionary.create();
            catalog.cosSetDests(destsDict);
        }
        COSObject destination = this.createDestination();
        destsDict.put(COSName.createUTF8((String)this.name), destination);
    }

    @Override
    protected ILayoutComponent createComponent() {
        return new LayoutPrimitive(0.0f, 0.0f);
    }

    protected COSObject createDestination() {
        COSArray destination = COSArray.create();
        destination.add(this.page.cosGetObject());
        COSFixed posLeft = COSFixed.create((float)this.getMinX());
        COSFixed posTop = COSFixed.create((float)this.getMaxY());
        destination.add((COSObject)PDExplicitDestination.CN_DISPLAY_MODE_XYZ);
        destination.add((COSObject)posLeft);
        destination.add((COSObject)posTop);
        destination.add((COSObject)COSFixed.create((float)0.0f));
        return destination;
    }

    @Override
    public boolean isControlElement() {
        return false;
    }

    @Override
    public boolean isTextElement() {
        return false;
    }

    @Override
    public void writeOn(ICSDevice device) {
        this.addNamedDestination();
    }
}

