/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.annotation;

import de.intarsys.html.IHtmlTag;
import de.intarsys.pdf.layout.html.annotation.PDLAnchor;
import de.intarsys.pdf.layout.html.annotation.PDLLinkEnd;
import de.intarsys.pdf.layout.html.annotation.PDLLinkStart;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.layout.parser.PDLParseException;
import de.intarsys.pdf.pd.PDPage;
import java.util.List;

public class PDLHtmlTagA
extends PDLHtmlTag {
    private String href;
    private String name;
    private PDLLinkStart start;
    private PDLLinkEnd end;

    public PDLHtmlTagA(PDLHtmlHandler handler, PDLHtmlTag parent, IHtmlTag htmlTag) {
        super(handler, parent, htmlTag, parent.getHtmlElement());
    }

    @Override
    public void ended() throws PDLParseException {
        if (this.isReference()) {
            this.endLink();
        }
        super.ended();
    }

    protected void endLink() {
        this.end = new PDLLinkEnd(this.start, this.getActivePad(), this.getPDEParser(), this.href);
        this.getActivePad().layoutElement(this.end);
    }

    public String getHref() {
        return this.href;
    }

    @Override
    public void handleOverflow(List overflow) throws PDLParseException {
        if (this.isReference()) {
            this.endLink();
            this.start = new PDLLinkStart();
            this.end = null;
            overflow.add(0, this.start);
        }
    }

    protected boolean isAnchor() {
        return !this.isReference() && this.name != null;
    }

    protected boolean isReference() {
        return this.href != null;
    }

    @Override
    public void started() throws PDLParseException {
        super.started();
        this.href = this.getHtmlTag().getAttribute("href");
        this.name = this.getHtmlTag().getAttribute("name");
        if (this.isReference()) {
            this.start = new PDLLinkStart();
            this.getActivePad().layoutElement(this.start);
        } else if (this.isAnchor()) {
            PDPage page = (PDPage)this.getPDEParser().getAttribute("page");
            PDLAnchor anchor = new PDLAnchor(page, this.name);
            this.getActivePad().layoutElement(anchor);
        }
    }
}

