/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.form;

import de.intarsys.html.IHtmlTag;
import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.app.appearance.AppearanceCreatorRegistry;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.content.common.CSBoundingBoxCollector;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.layout.parser.PDLParseException;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public abstract class PDLAnnotationTag
extends PDLHtmlTag {
    private static final String WIDTH_STRING = "o";
    private PDAnnotation annotation;
    private IAnnotationFactory factory;

    protected PDLAnnotationTag(PDLHtmlHandler handler, PDLHtmlTag parent, IHtmlTag htmlTag) {
        super(handler, parent, htmlTag, parent.getHtmlElement());
    }

    protected void annotationEnded() {
    }

    protected void annotationStarted() {
    }

    protected abstract IAnnotationFactory createFactory();

    @Override
    public void ended() throws PDLParseException {
        this.annotationEnded();
        IAppearanceCreator creator = AppearanceCreatorRegistry.get().lookupAppearanceCreator(PDWidgetAnnotation.CN_Subtype_Widget);
        if (creator != null) {
            this.getAnnotation().setAppearance(creator.createAppearance(this.getAnnotation(), null));
        }
        super.ended();
    }

    protected PDAdditionalActions getAdditionalActions(PDAcroFormField field) {
        PDAdditionalActions additionalActions = field.getAdditionalActions();
        if (additionalActions == null) {
            additionalActions = (PDAdditionalActions)PDAdditionalActions.META.createNew();
            field.setAdditionalActions(additionalActions);
        }
        return additionalActions;
    }

    protected PDAnnotation getAnnotation() {
        return this.annotation;
    }

    protected IAnnotationFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.createFactory();
        }
        return this.factory;
    }

    protected Map getFactoryAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        String name = this.getHtmlTag().getAttribute("name");
        attributes.put("fieldName", name);
        return attributes;
    }

    protected float getFontHeight() {
        PDFont font = this.getActivePad().getTextFormat().getFont();
        float fontSize = this.getActivePad().getTextFormat().getFontSize();
        return PDFontTools.getGlyphHeightScaled((PDFont)font, (float)fontSize);
    }

    protected float getTextWidth(int length) {
        StringBuffer b = new StringBuffer(length);
        for (int i = 0; i <= length; ++i) {
            b.append(WIDTH_STRING);
        }
        return this.getTextWidth(b.toString());
    }

    protected float getTextWidth(String text) {
        PDFont font = this.getActivePad().getTextFormat().getFont();
        float fontSize = this.getActivePad().getTextFormat().getFontSize();
        CSBoundingBoxCollector bbc = new CSBoundingBoxCollector();
        bbc.open(null);
        bbc.textBegin();
        bbc.textSetFont(null, font, fontSize);
        bbc.textShow(text);
        bbc.textEnd();
        Rectangle2D rect = bbc.getBoundingBox();
        if (rect == null) {
            return fontSize / 2.0f;
        }
        return (float)rect.getWidth();
    }

    protected void setAnnotation(PDAnnotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public void started() throws PDLParseException {
        super.started();
        PDPage page = (PDPage)this.getPDEParser().getAttribute("page");
        if (page == null) {
            return;
        }
        Rectangle2D.Float bbox = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        try {
            this.setAnnotation(this.getFactory().createAnnotation(page, (Rectangle2D)bbox, this.getFactoryAttributes()));
        }
        catch (ObjectCreationException e) {
            e.printStackTrace();
        }
        this.annotationStarted();
    }
}

