/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.form;

import de.intarsys.html.IHtmlTag;
import de.intarsys.pdf.app.annotation.AnnotationOutlet;
import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.layout.html.form.PDLWidgetTag;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.pd.AcroFormFieldFlags;
import de.intarsys.pdf.pd.PDAFButtonField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDActionResetForm;
import de.intarsys.pdf.pd.PDActionSubmitForm;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceTools;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class PDLHtmlTagINPUT
extends PDLWidgetTag {
    protected PDLHtmlTagINPUT(PDLHtmlHandler handler, PDLHtmlTag parent, IHtmlTag htmlTag) {
        super(handler, parent, htmlTag);
    }

    @Override
    protected void annotationStarted() {
        super.annotationStarted();
        if (this.isTypeText()) {
            this.configureWidgetText();
            this.layoutVisible();
        }
        if (this.isTypePassword()) {
            this.configureWidgetPassword();
            this.layoutVisible();
        }
        if (this.isTypeHidden()) {
            this.configureWidgetHidden();
            this.layoutHidden();
        }
        if (this.isTypeRadio()) {
            this.configureWidgetChoicebutton();
            this.layoutVisible();
        }
        if (this.isTypeCheckbox()) {
            this.configureWidgetChoicebutton();
            this.layoutVisible();
        }
        if (this.isTypeSubmit()) {
            this.configureWidgetSubmit();
            this.layoutVisible();
        }
        if (this.isTypeReset()) {
            this.configureWidgetReset();
            this.layoutVisible();
        }
        if (this.isTypeButton()) {
            this.configureWidgetButton();
            this.layoutVisible();
        }
        if (this.isTypeSignature()) {
            this.configureWidgetSignature();
            this.layoutVisible();
        }
    }

    protected void configureWidgetButton() {
        this.applyCurrentFont();
        float height = this.getFontHeight() * 1.5f;
        float width = 120.0f;
        String label = this.getHtmlTag().getAttribute("value");
        if (label != null) {
            this.getWidget().getAppearanceCharacteristics().setNormalCaption(label);
            width = this.getTextWidth(label) * 1.5f;
        }
        CDSRectangle rect = this.getWidget().getRectangle().copy();
        rect.setHeight(height);
        rect.setWidth(width);
        this.getWidget().setRectangle(rect);
    }

    protected void configureWidgetChoicebutton() {
        String checked;
        CDSRectangle rect = this.getWidget().getRectangle().copy();
        float size = this.getActivePad().getTextFormat().getFontSize();
        rect.setHeight(size);
        rect.setWidth(size);
        this.getWidget().setRectangle(rect);
        String exportValue = this.getHtmlTag().getAttribute("value");
        if (exportValue != null) {
            String oldState = PDAnnotationTools.getStateChecked((PDWidgetAnnotation)this.getWidget()).stringValue();
            PDAppearanceTools.renameState((PDAppearance)this.getWidget().getAppearance(), (String)oldState, (String)exportValue);
        }
        if ((checked = this.getHtmlTag().getAttribute("checked")) != null) {
            PDAFButtonField field = (PDAFButtonField)this.getWidget().getAcroFormField().getLogicalRoot();
            String state = PDAnnotationTools.getStateChecked((PDWidgetAnnotation)this.getWidget()).stringValue();
            field.setDefaultValue(state);
            field.setValueString(state);
        }
    }

    protected void configureWidgetHidden() {
        this.applyCurrentFont();
        PDAcroFormField field = this.getWidget().getAcroFormField();
        PDAcroFormField root = field.getLogicalRoot();
        int size = 10;
        CDSRectangle rect = this.getWidget().getRectangle().copy();
        rect.setHeight(this.getFontHeight() * 1.2f);
        rect.setWidth(this.getTextWidth(size));
        this.getWidget().setRectangle(rect);
        String value = this.getHtmlTag().getAttribute("value");
        if (value != null) {
            root.setDefaultValue(value);
            root.setValueString(value);
        }
        this.getWidget().setHidden(true);
    }

    protected void configureWidgetPassword() {
        this.configureWidgetText();
        this.getWidget().getAcroFormField().getLogicalRoot().getFieldFlags().setPassword(true);
    }

    protected void configureWidgetReset() {
        this.configureWidgetButton();
        PDActionResetForm action = PDActionResetForm.createNew();
        this.getWidget().setAction((PDAction)action);
    }

    protected void configureWidgetSignature() {
        this.applyCurrentFont();
        PDAcroFormField field = this.getWidget().getAcroFormField();
        PDAcroFormField root = field.getLogicalRoot();
        String sizeString = this.getHtmlTag().getAttribute("size");
        int size = 30;
        if (sizeString != null) {
            size = Integer.parseInt(sizeString);
        }
        sizeString = this.getHtmlTag().getAttribute("height");
        int height = 30;
        if (sizeString != null) {
            height = Integer.parseInt(sizeString);
        }
        CDSRectangle rect = this.getWidget().getRectangle().copy();
        rect.setHeight((float)height);
        rect.setWidth(this.getTextWidth(size));
        this.getWidget().setRectangle(rect);
        String value = this.getHtmlTag().getAttribute("value");
        if (value != null) {
            // empty if block
        }
    }

    protected void configureWidgetSubmit() {
        this.configureWidgetButton();
        String formAction = this.getFormElement().getAction();
        if (formAction == null) {
            return;
        }
        URL url = null;
        try {
            url = new URL(formAction);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return;
        }
        PDActionSubmitForm action = PDActionSubmitForm.createNew((URL)url);
        this.getWidget().setAction((PDAction)action);
    }

    protected void configureWidgetText() {
        String value;
        this.applyCurrentFont();
        PDAcroFormField field = this.getWidget().getAcroFormField();
        PDAcroFormField root = field.getLogicalRoot();
        String sizeString = this.getHtmlTag().getAttribute("size");
        int size = 30;
        if (sizeString != null) {
            size = Integer.parseInt(sizeString);
        }
        CDSRectangle rect = this.getWidget().getRectangle().copy();
        rect.setHeight(this.getFontHeight() * 1.0f);
        rect.setWidth(this.getTextWidth(size));
        this.getWidget().setRectangle(rect);
        String maxLengthString = this.getHtmlTag().getAttribute("maxlength");
        if (maxLengthString != null) {
            root.setMaxLength(Integer.valueOf(Integer.parseInt(maxLengthString)));
        }
        if ((value = this.getHtmlTag().getAttribute("value")) != null) {
            root.setDefaultValue(value);
            root.setValueString(value);
        }
    }

    @Override
    protected IAnnotationFactory createFactory() {
        return AnnotationOutlet.get().lookupAnnotationFactory(PDWidgetAnnotation.CN_Subtype_Widget);
    }

    @Override
    protected Map getFactoryAttributes() {
        Map attributes = super.getFactoryAttributes();
        AcroFormFieldFlags flags = new AcroFormFieldFlags(0);
        if (this.isTypeText()) {
            attributes.put(PDAcroFormField.DK_FT, PDAcroFormField.CN_FT_Tx);
        }
        if (this.isTypeHidden()) {
            attributes.put(PDAcroFormField.DK_FT, PDAcroFormField.CN_FT_Tx);
        }
        if (this.isTypePassword()) {
            attributes.put(PDAcroFormField.DK_FT, PDAcroFormField.CN_FT_Tx);
            flags.setPassword(true);
        }
        if (this.isTypeRadio()) {
            attributes.put(PDAcroFormField.DK_FT, PDAcroFormField.CN_FT_Btn);
            flags.setRadio(true);
            flags.setPushbutton(false);
        }
        if (this.isTypeCheckbox()) {
            attributes.put(PDAcroFormField.DK_FT, PDAcroFormField.CN_FT_Btn);
            flags.setRadio(false);
            flags.setPushbutton(false);
        }
        if (this.isTypeSubmit() || this.isTypeReset() || this.isTypeButton()) {
            attributes.put(PDAcroFormField.DK_FT, PDAcroFormField.CN_FT_Btn);
            flags.setRadio(false);
            flags.setPushbutton(true);
        }
        if (this.isTypeSignature()) {
            attributes.put(PDAcroFormField.DK_FT, PDAcroFormField.CN_FT_Sig);
        }
        attributes.put(PDAcroFormField.DK_Ff, flags);
        return attributes;
    }

    protected String getType() {
        String type = this.getHtmlTag().getAttribute("type");
        return type;
    }

    protected boolean isTypeButton() {
        return "button".equalsIgnoreCase(this.getType());
    }

    protected boolean isTypeCheckbox() {
        return "checkbox".equalsIgnoreCase(this.getType());
    }

    protected boolean isTypeHidden() {
        return "hidden".equalsIgnoreCase(this.getType());
    }

    protected boolean isTypePassword() {
        return "password".equalsIgnoreCase(this.getType());
    }

    protected boolean isTypeRadio() {
        return "radio".equalsIgnoreCase(this.getType());
    }

    protected boolean isTypeReset() {
        return "reset".equalsIgnoreCase(this.getType());
    }

    protected boolean isTypeSignature() {
        return "signature".equalsIgnoreCase(this.getType());
    }

    protected boolean isTypeSubmit() {
        return "submit".equalsIgnoreCase(this.getType());
    }

    protected boolean isTypeText() {
        return "text".equalsIgnoreCase(this.getType());
    }
}

