/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.form;

import de.intarsys.html.IHtmlTag;
import de.intarsys.pdf.app.annotation.AnnotationOutlet;
import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.layout.html.form.PDLWidgetTag;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.pd.AcroFormFieldFlags;
import de.intarsys.pdf.pd.PDAFChoiceField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.Map;

public class PDLHtmlTagSELECT
extends PDLWidgetTag {
    protected PDLHtmlTagSELECT(PDLHtmlHandler handler, PDLHtmlTag parent, IHtmlTag htmlTag) {
        super(handler, parent, htmlTag);
    }

    @Override
    protected void annotationEnded() {
        this.getWidget().setRectangle(this.calculateRect());
        this.layoutVisible();
        super.annotationEnded();
    }

    @Override
    protected void annotationStarted() {
        super.annotationStarted();
        this.applyCurrentFont();
        String multipleString = this.getHtmlTag().getAttribute("multiple");
        if (multipleString != null) {
            PDAcroFormField root = this.getWidget().getAcroFormField().getLogicalRoot();
            root.getFieldFlags().setMultiSelect(true);
        }
    }

    protected CDSRectangle calculateRect() {
        if (this.isTypeCombo()) {
            return this.calculateRectCombo();
        }
        if (this.isTypeList()) {
            return this.calculateRectList();
        }
        return this.getWidget().getRectangle();
    }

    protected CDSRectangle calculateRectCombo() {
        CDSRectangle rect = this.getWidget().getRectangle().copy();
        rect.setHeight(this.getFontHeight() * 1.2f);
        rect.setWidth(this.getTextWidth(this.getMaxText()));
        return rect;
    }

    protected CDSRectangle calculateRectList() {
        int size = this.getSize();
        if (size <= 0) {
            size = this.getEntryCount();
        }
        CDSRectangle rect = this.getWidget().getRectangle().copy();
        rect.setHeight(this.getFontHeight() * 1.1f * (float)size);
        rect.setWidth(this.getTextWidth(this.getMaxText()));
        return rect;
    }

    @Override
    protected IAnnotationFactory createFactory() {
        return AnnotationOutlet.get().lookupAnnotationFactory(PDWidgetAnnotation.CN_Subtype_Widget);
    }

    protected int getEntryCount() {
        PDAFChoiceField field = (PDAFChoiceField)this.getWidget().getAcroFormField().getLogicalRoot();
        return field.getOptionNames().size();
    }

    @Override
    protected Map getFactoryAttributes() {
        Map attributes = super.getFactoryAttributes();
        attributes.put(PDAcroFormField.DK_FT, PDAcroFormField.CN_FT_Ch);
        AcroFormFieldFlags flags = new AcroFormFieldFlags(0);
        flags.setCombo(this.isTypeCombo());
        attributes.put(PDAcroFormField.DK_Ff, flags);
        return attributes;
    }

    protected String getMaxText() {
        String max = "";
        PDAFChoiceField field = (PDAFChoiceField)this.getWidget().getAcroFormField().getLogicalRoot();
        for (String option : field.getOptionNames()) {
            int length = option.length();
            if (length <= max.length()) continue;
            max = option;
        }
        return max;
    }

    protected int getSize() {
        String sizeString = this.getHtmlTag().getAttribute("size");
        int size = 1;
        if (sizeString != null) {
            size = Integer.parseInt(sizeString);
        }
        return size;
    }

    protected boolean isTypeCombo() {
        return this.getSize() == 1;
    }

    protected boolean isTypeList() {
        return !this.isTypeCombo();
    }
}

