/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.form;

import de.intarsys.html.IHtmlTag;
import de.intarsys.pdf.app.annotation.AnnotationOutlet;
import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.layout.html.form.PDLWidgetTag;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.layout.parser.PDLParseException;
import de.intarsys.pdf.pd.AcroFormFieldFlags;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.Map;

public class PDLHtmlTagTEXTAREA
extends PDLWidgetTag {
    protected PDLHtmlTagTEXTAREA(PDLHtmlHandler handler, PDLHtmlTag parent, IHtmlTag htmlTag) {
        super(handler, parent, htmlTag);
    }

    @Override
    protected void annotationStarted() {
        super.annotationStarted();
        this.applyCurrentFont();
        this.getWidget().getAcroFormField().getFieldFlags().setMultiline(true);
        String colsString = this.getHtmlTag().getAttribute("cols");
        int cols = 30;
        if (colsString != null) {
            cols = Integer.parseInt(colsString);
        }
        String rowsString = this.getHtmlTag().getAttribute("rows");
        int rows = 5;
        if (rowsString != null) {
            rows = Integer.parseInt(rowsString);
        }
        CDSRectangle rect = this.getWidget().getRectangle().copy();
        rect.setHeight(this.getFontHeight() * 1.2f * (float)rows);
        rect.setWidth(this.getTextWidth(cols));
        this.getWidget().setRectangle(rect);
        this.layoutVisible();
    }

    @Override
    protected IAnnotationFactory createFactory() {
        return AnnotationOutlet.get().lookupAnnotationFactory(PDWidgetAnnotation.CN_Subtype_Widget);
    }

    @Override
    protected Map getFactoryAttributes() {
        Map attributes = super.getFactoryAttributes();
        AcroFormFieldFlags flags = new AcroFormFieldFlags(0);
        attributes.put(PDAcroFormField.DK_FT, PDAcroFormField.CN_FT_Tx);
        flags.setMultiline(true);
        attributes.put(PDAcroFormField.DK_Ff, flags);
        return attributes;
    }

    @Override
    public void text(char[] data, int start, int length) throws PDLParseException {
        PDAcroFormField field = this.getWidget().getAcroFormField();
        PDAcroFormField root = field.getLogicalRoot();
        String value = new String(data, start, length);
        if (value != null) {
            root.setDefaultValue(value);
            root.setValueString(value);
        }
    }
}

