/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.form;

import de.intarsys.html.IHtmlTag;
import de.intarsys.html.IHtmlTagImpl;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.layout.html.form.PDLAnnotationElement;
import de.intarsys.pdf.layout.html.form.PDLAnnotationTag;
import de.intarsys.pdf.layout.html.form.PDLHtmlTagFORM;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDActionJavaScript;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.ArrayList;
import java.util.List;

public abstract class PDLWidgetTag
extends PDLAnnotationTag {
    protected static List events = new ArrayList();

    protected PDLWidgetTag(PDLHtmlHandler handler, PDLHtmlTag parent, IHtmlTag htmlTag) {
        super(handler, parent, htmlTag);
    }

    protected void addAction(Event event, String javascript) {
        PDAdditionalActions actions = null;
        actions = event.rootEvent ? this.getFieldActions() : this.getWidgetActions();
        PDActionJavaScript action = PDActionJavaScript.createNew((String)javascript);
        actions.addAction(event.cosName, (PDAction)action);
    }

    @Override
    protected void annotationEnded() {
    }

    @Override
    protected void annotationStarted() {
        String align;
        String disabledString;
        String readonlyString = this.getHtmlTag().getAttribute("readonly");
        if (readonlyString != null) {
            this.getWidget().getAcroFormField().setReadOnly(true);
        }
        if ((disabledString = this.getHtmlTag().getAttribute("disabled")) != null) {
            this.getWidget().getAcroFormField().setReadOnly(true);
        }
        if ((align = this.getHtmlTag().getAttribute("align")) != null) {
            if (align.equalsIgnoreCase("center")) {
                this.getWidget().getAcroFormField().setAlignmentCenter();
            } else if (align.equalsIgnoreCase("left")) {
                this.getWidget().getAcroFormField().setAlignmentLeft();
            } else if (align.equalsIgnoreCase("right")) {
                this.getWidget().getAcroFormField().setAlignmentRight();
            }
        }
        for (Event event : events) {
            String jsAction = this.getHtmlTag().getAttribute(event.htmlName);
            if (jsAction == null) continue;
            this.addAction(event, jsAction);
        }
        PDAcroFormField field = this.getWidget().getAcroFormField().getLogicalRoot();
        PDAdditionalActions fieldActions = field.getAdditionalActions();
        if (fieldActions != null && fieldActions.getAction(PDAdditionalActions.CN_trigger_C) != null) {
            this.calculationOrderAdd(field);
        }
    }

    protected void applyCurrentFont() {
        PDLTextFormat textFormat = this.getActivePad().getTextFormat();
        float fontSize = textFormat.getFontSize();
        PDFont font = textFormat.getFont();
        PDAcroFormField field = this.getWidget().getAcroFormField();
        field.setDefaultAppearanceFontSize(fontSize);
        field.setDefaultAppearanceFont(font);
    }

    protected void calculationOrderAdd(PDAcroFormField field) {
        COSObject cosField = field.cosGetObject();
        PDAcroForm form = field.getAcroForm();
        COSArray co = form.cosGetField(PDAcroForm.DK_CO).asArray();
        if (co == null) {
            co = COSArray.create();
            form.cosSetField(PDAcroForm.DK_CO, (COSObject)co);
        }
        if (co.indexOf(cosField) < 0) {
            co.add(cosField);
        }
    }

    @Override
    protected PDAdditionalActions getAdditionalActions(PDAcroFormField field) {
        PDAdditionalActions additionalActions = field.getAdditionalActions();
        if (additionalActions == null) {
            additionalActions = (PDAdditionalActions)PDAdditionalActions.META.createNew();
            field.setAdditionalActions(additionalActions);
        }
        return additionalActions;
    }

    protected PDAdditionalActions getFieldActions() {
        return this.getAdditionalActions(this.getWidget().getAcroFormField().getLogicalRoot());
    }

    protected PDLHtmlTagFORM getFormElement() {
        for (IHtmlTagImpl parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PDLHtmlTagFORM)) continue;
            return (PDLHtmlTagFORM)parent;
        }
        return null;
    }

    protected PDWidgetAnnotation getWidget() {
        return (PDWidgetAnnotation)this.getAnnotation();
    }

    protected PDAdditionalActions getWidgetActions() {
        return this.getAdditionalActions(this.getWidget().getAcroFormField());
    }

    protected void layoutHidden() {
        this.getFormElement().addHiddenAnnotation((PDAnnotation)this.getWidget());
    }

    protected void layoutVisible() {
        PDLAnnotationElement filler = new PDLAnnotationElement(this.getAnnotation(), this.getPDEParser());
        this.getActivePad().layoutElement(filler);
    }

    static {
        events.add(new Event("onclick", PDAdditionalActions.CN_trigger_U));
        events.add(new Event("onmousedown", PDAdditionalActions.CN_trigger_D));
        events.add(new Event("onmouseup", PDAdditionalActions.CN_trigger_U));
        events.add(new Event("onmouseover", PDAdditionalActions.CN_trigger_E));
        events.add(new Event("onmouseout", PDAdditionalActions.CN_trigger_X));
        events.add(new Event("onkeypress", PDAdditionalActions.CN_trigger_K, true));
        events.add(new Event("onkeydown", PDAdditionalActions.CN_trigger_K, true));
        events.add(new Event("onkeyup", PDAdditionalActions.CN_trigger_K, true));
        events.add(new Event("onblur", PDAdditionalActions.CN_trigger_Bl));
        events.add(new Event("onfocus", PDAdditionalActions.CN_trigger_Fo));
        events.add(new Event("onformat", PDAdditionalActions.CN_trigger_F, true));
        events.add(new Event("onvalidate", PDAdditionalActions.CN_trigger_V, true));
        events.add(new Event("oncalculate", PDAdditionalActions.CN_trigger_C, true));
        events.add(new Event("onpageopen", PDAdditionalActions.CN_trigger_PO));
        events.add(new Event("onpageclose", PDAdditionalActions.CN_trigger_PC));
        events.add(new Event("onpagevisible", PDAdditionalActions.CN_trigger_PV));
        events.add(new Event("onpageinvisible", PDAdditionalActions.CN_trigger_PI));
    }

    protected static class Event {
        public String htmlName;
        public COSName cosName;
        public boolean rootEvent;

        public Event(String htmlName, COSName cosName) {
            this(htmlName, cosName, false);
        }

        public Event(String htmlName, COSName cosName, boolean rootEvent) {
            this.htmlName = htmlName;
            this.cosName = cosName;
            this.rootEvent = rootEvent;
        }
    }
}

