/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.model;

import de.intarsys.pdf.layout.html.model.AbsoluteContentExtensionFunctor;
import de.intarsys.pdf.layout.html.model.AbsoluteTotalExtensionFunctor;
import de.intarsys.pdf.layout.html.model.ColumnProportionalWidthFunctor;
import de.intarsys.pdf.layout.html.model.HtmlBorder;
import de.intarsys.pdf.layout.html.model.HtmlElement;
import de.intarsys.pdf.layout.html.model.IExtensionFunctor;
import de.intarsys.pdf.layout.html.model.RelativePercentExtensionFunctor;
import de.intarsys.pdf.layout.html.parser.PDLCssTools;

public abstract class Extension {
    private Extension defaultExtension;
    private final HtmlElement element;
    private IExtensionFunctor extensionFunctor = null;
    private float contentExtension = Float.NaN;
    private float extensionValue = Float.NaN;
    private float lowerMargin = Float.NaN;
    private float lowerPadding = Float.NaN;
    private float totalExtension = Float.NaN;
    private float upperMargin = Float.NaN;
    private float upperPadding = Float.NaN;

    public static boolean isDefault(float value) {
        return Float.isNaN(value);
    }

    public Extension(HtmlElement element) {
        this.element = element;
        this.setTotalExtension(0.0f);
    }

    public float basicContentExtension() {
        return this.contentExtension;
    }

    public float basicTotalExtension() {
        return this.totalExtension;
    }

    public void defineExtension(String definition) {
        if (definition == null) {
            return;
        }
        if ((definition = definition.trim()).endsWith("%")) {
            if (this.getContainerExtension() != null && !this.getContainerExtension().mayBeContainer()) {
                this.setExtensionFunctor(AbsoluteContentExtensionFunctor.UNIQUE);
            } else {
                float percent = Float.parseFloat(definition.substring(0, definition.length() - 1));
                this.setExtensionValue(percent);
                this.setExtensionFunctor(RelativePercentExtensionFunctor.UNIQUE);
            }
        } else if (definition.endsWith("*")) {
            if (this.getContainerExtension() != null && !this.getContainerExtension().mayBeContainer()) {
                this.setExtensionFunctor(AbsoluteContentExtensionFunctor.UNIQUE);
            } else {
                float proportion = Float.parseFloat(definition.substring(0, definition.length() - 1));
                this.setExtensionValue(proportion);
                this.setExtensionFunctor(ColumnProportionalWidthFunctor.UNIQUE);
            }
        } else {
            float absolute = PDLCssTools.getSize(definition);
            this.setExtensionValue(absolute);
            this.setTotalExtension(absolute);
        }
    }

    protected HtmlBorder getBorder() {
        return this.getElement().getBorder();
    }

    protected float getBorderWidth() {
        HtmlBorder border = this.getBorder();
        if (border == null) {
            return 0.0f;
        }
        return border.getWidth();
    }

    protected abstract Extension getContainerExtension();

    public float getContentExtension() {
        return this.getExtensionFunctor().getContentExtension(this);
    }

    protected float getDefaultBorderWidth() {
        if (this.defaultExtension == null) {
            return 0.0f;
        }
        return this.getDefaultExtension().getBorderWidth();
    }

    public Extension getDefaultExtension() {
        return this.defaultExtension;
    }

    protected float getDefaultLowerMargin() {
        if (this.defaultExtension == null) {
            return 0.0f;
        }
        return this.getDefaultExtension().getLowerMargin();
    }

    protected float getDefaultLowerPadding() {
        if (this.defaultExtension == null) {
            return 0.0f;
        }
        return this.getDefaultExtension().getLowerPadding();
    }

    protected float getDefaultUpperMargin() {
        if (this.defaultExtension == null) {
            return 0.0f;
        }
        return this.getDefaultExtension().getUpperMargin();
    }

    protected float getDefaultUpperPadding() {
        if (this.defaultExtension == null) {
            return 0.0f;
        }
        return this.getDefaultExtension().getUpperPadding();
    }

    public HtmlElement getElement() {
        return this.element;
    }

    public IExtensionFunctor getExtensionFunctor() {
        return this.extensionFunctor;
    }

    protected float getExtensionValue() {
        return this.extensionValue;
    }

    public float getLowerMargin() {
        if (Extension.isDefault(this.lowerMargin)) {
            return this.getDefaultLowerMargin();
        }
        return this.lowerMargin;
    }

    public float getLowerPadding() {
        if (Extension.isDefault(this.lowerPadding)) {
            return this.getDefaultLowerPadding();
        }
        return this.lowerPadding;
    }

    public float getNonContentExtension() {
        return this.getLowerMargin() + this.getLowerPadding() + this.getUpperMargin() + this.getUpperPadding() + 2.0f * this.getBorderWidth();
    }

    public float getTotalExtension() {
        return this.getExtensionFunctor().getTotalExtension(this);
    }

    public float getUpperMargin() {
        if (Extension.isDefault(this.upperMargin)) {
            return this.getDefaultUpperMargin();
        }
        return this.upperMargin;
    }

    public float getUpperPadding() {
        if (Extension.isDefault(this.upperPadding)) {
            return this.getDefaultUpperPadding();
        }
        return this.upperPadding;
    }

    public boolean isExtensionValueDefined() {
        return !Extension.isDefault(this.extensionValue);
    }

    public boolean mayBeContainer() {
        return this.extensionFunctor.mayBeContainer(this);
    }

    public void setContentExtension(float extension) {
        this.totalExtension = Float.NaN;
        this.contentExtension = extension;
        this.extensionFunctor = AbsoluteContentExtensionFunctor.UNIQUE;
    }

    public void setDefaultExtension(Extension defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    public void setExtensionFunctor(IExtensionFunctor extensionFunctor) {
        this.extensionFunctor = extensionFunctor;
    }

    protected void setExtensionValue(float extensionValue) {
        this.extensionValue = extensionValue;
    }

    public void setLowerMargin(float lowerMargin) {
        this.lowerMargin = lowerMargin;
    }

    public void setLowerPadding(float lowerPadding) {
        this.lowerPadding = lowerPadding;
    }

    public void setTotalExtension(float extension) {
        this.totalExtension = extension;
        this.contentExtension = Float.NaN;
        this.extensionFunctor = AbsoluteTotalExtensionFunctor.UNIQUE;
    }

    public void setUpperMargin(float upperMargin) {
        this.upperMargin = upperMargin;
    }

    public void setUpperPadding(float upperPadding) {
        this.upperPadding = upperPadding;
    }
}

