/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.model;

import de.intarsys.tools.hex.HexTools;

public class HtmlColor {
    private static final float CONST_255 = 255.0f;
    public static final HtmlColor BLACK = HtmlColor.createColor(0.0f, 0.0f, 0.0f);
    public static final HtmlColor WHITE = HtmlColor.createColor(1.0f, 1.0f, 1.0f);
    private float blue;
    private float green;
    private float red;

    public static HtmlColor createColor(float red, float green, float blue) {
        return new HtmlColor(red, green, blue);
    }

    public static HtmlColor createColor(String definition) {
        if (definition == null || definition.length() == 0) {
            return null;
        }
        if (definition.charAt(0) == '#' && definition.length() == 7) {
            String redChannel = definition.substring(1, 3);
            String greenChannel = definition.substring(3, 5);
            String blueChannel = definition.substring(5, 7);
            return HtmlColor.createColor((float)HexTools.hexStringToInt((String)redChannel) / 255.0f, (float)HexTools.hexStringToInt((String)greenChannel) / 255.0f, (float)HexTools.hexStringToInt((String)blueChannel) / 255.0f);
        }
        return null;
    }

    protected HtmlColor(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getGreen() {
        return this.green;
    }

    public float getRed() {
        return this.red;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public void setRed(float red) {
        this.red = red;
    }
}

