/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.model;

import de.intarsys.html.IStyle;
import de.intarsys.pdf.layout.html.model.Extension;
import de.intarsys.pdf.layout.html.model.HorizontalExtension;
import de.intarsys.pdf.layout.html.model.HtmlBorder;
import de.intarsys.pdf.layout.html.model.HtmlColor;
import de.intarsys.pdf.layout.html.model.VerticalExtension;
import de.intarsys.pdf.layout.html.parser.PDLCssTools;

public abstract class HtmlElement {
    private final Extension horizontalExtension = new HorizontalExtension(this);
    private final Extension verticalExtension = new VerticalExtension(this);
    private final HtmlElement parent;
    private HtmlBorder border = null;
    private HtmlColor bgColor = null;
    private float descent;

    public static boolean isDefault(float value) {
        return Float.isNaN(value);
    }

    public HtmlElement(HtmlElement parent) {
        this.parent = parent;
    }

    public void defineBgColor(String definition) {
        if (definition == null) {
            return;
        }
        this.setBgColor(HtmlColor.createColor(definition));
    }

    public void defineBorder(String definition) {
        if (definition == null) {
            return;
        }
        if (definition.trim().length() == 0 || definition.equals("border") || definition.equals("#DEFAULT")) {
            this.setBorder(new HtmlBorder());
            this.getBorder().setWidth(1.0f);
            return;
        }
        float bw = Float.parseFloat(definition);
        if (bw > 0.0f) {
            this.setBorder(new HtmlBorder());
            this.getBorder().setWidth(bw);
        }
    }

    public void defineHeight(String definition) {
        this.getVerticalExtension().defineExtension(definition);
        this.setContentHeight(this.getVerticalExtension().getTotalExtension() - this.getNonContentHeight());
    }

    public void defineStyle(IStyle style) {
        String heightDefinition;
        float value;
        if (style == null) {
            return;
        }
        String paddingStr = style.getPropertyValue("padding");
        if (paddingStr != null) {
            value = PDLCssTools.getSize(paddingStr);
            this.setLeftPadding(value);
            this.setRightPadding(value);
            this.setTopPadding(value);
            this.setBottomPadding(value);
        }
        if ((paddingStr = style.getPropertyValue("padding-left")) != null) {
            value = PDLCssTools.getSize(paddingStr);
            this.setLeftPadding(value);
        }
        if ((paddingStr = style.getPropertyValue("padding-right")) != null) {
            value = PDLCssTools.getSize(paddingStr);
            this.setRightPadding(value);
        }
        if ((paddingStr = style.getPropertyValue("padding-top")) != null) {
            value = PDLCssTools.getSize(paddingStr);
            this.setTopPadding(value);
        }
        if ((paddingStr = style.getPropertyValue("padding-bottom")) != null) {
            value = PDLCssTools.getSize(paddingStr);
            this.setBottomPadding(value);
        }
        if ((heightDefinition = style.getPropertyValue("height")) != null) {
            this.defineHeight(heightDefinition);
        }
    }

    public void defineWidth(String definition) {
        this.getHorizontalExtension().defineExtension(definition);
    }

    public HtmlColor getBgColor() {
        if (this.bgColor == null) {
            return this.getDefaultBgColor();
        }
        return this.bgColor;
    }

    public HtmlBorder getBorder() {
        if (this.border == null) {
            return this.getDefaultBorder();
        }
        return this.border;
    }

    public float getBottomMargin() {
        return this.getVerticalExtension().getLowerMargin();
    }

    public float getBottomPadding() {
        return this.getVerticalExtension().getLowerPadding();
    }

    public float getContentHeight() {
        return this.getVerticalExtension().getContentExtension();
    }

    public float getContentWidth() {
        return this.getHorizontalExtension().getContentExtension();
    }

    protected HtmlColor getDefaultBgColor() {
        return HtmlColor.WHITE;
    }

    protected HtmlBorder getDefaultBorder() {
        return null;
    }

    public float getDescent() {
        return this.descent;
    }

    public float getHeight() {
        return this.getVerticalExtension().getTotalExtension();
    }

    public Extension getHorizontalExtension() {
        return this.horizontalExtension;
    }

    public float getLeftMargin() {
        return this.getHorizontalExtension().getLowerMargin();
    }

    public float getLeftPadding() {
        return this.getHorizontalExtension().getLowerPadding();
    }

    public float getNonContentHeight() {
        return this.getVerticalExtension().getNonContentExtension();
    }

    public float getNonContentWidth() {
        return this.getHorizontalExtension().getNonContentExtension();
    }

    public HtmlElement getParent() {
        return this.parent;
    }

    public float getRightMargin() {
        return this.getHorizontalExtension().getUpperMargin();
    }

    public float getRightPadding() {
        return this.getHorizontalExtension().getUpperPadding();
    }

    public float getTopMargin() {
        return this.getVerticalExtension().getUpperMargin();
    }

    public float getTopPadding() {
        return this.getVerticalExtension().getUpperPadding();
    }

    public Extension getVerticalExtension() {
        return this.verticalExtension;
    }

    public float getWidth() {
        return this.getHorizontalExtension().getTotalExtension();
    }

    public boolean isHorizontalExtensionValueDefined() {
        return this.horizontalExtension.isExtensionValueDefined();
    }

    public boolean isVerticalExtensionValueDefined() {
        return this.verticalExtension.isExtensionValueDefined();
    }

    public void setBgColor(HtmlColor bgColor) {
        if (bgColor == null) {
            throw new IllegalArgumentException("color may not be null");
        }
        this.bgColor = bgColor;
    }

    public void setBorder(HtmlBorder border) {
        this.border = border;
    }

    public void setBottomMargin(float bottomMargin) {
        this.getVerticalExtension().setLowerMargin(bottomMargin);
    }

    public void setBottomPadding(float bottomPadding) {
        this.getVerticalExtension().setLowerPadding(bottomPadding);
    }

    public void setContentHeight(float contentHeight) {
        this.getVerticalExtension().setContentExtension(contentHeight);
    }

    public void setContentWidth(float contentWidth) {
        this.getHorizontalExtension().setContentExtension(contentWidth);
    }

    public void setDescent(float descent) {
        this.descent = descent;
    }

    public void setHeight(float newHeight) {
        this.getVerticalExtension().setTotalExtension(newHeight);
    }

    public void setLeftMargin(float leftMargin) {
        this.getHorizontalExtension().setLowerMargin(leftMargin);
    }

    public void setLeftPadding(float leftPadding) {
        this.getHorizontalExtension().setLowerPadding(leftPadding);
    }

    public void setRightMargin(float rightMargin) {
        this.getHorizontalExtension().setUpperMargin(rightMargin);
    }

    public void setRightPadding(float rightPadding) {
        this.getHorizontalExtension().setUpperPadding(rightPadding);
    }

    public void setTopMargin(float topMargin) {
        this.getVerticalExtension().setUpperMargin(topMargin);
    }

    public void setTopPadding(float topPadding) {
        this.getVerticalExtension().setUpperPadding(topPadding);
    }

    public void setWidth(float newWidth) {
        this.getHorizontalExtension().setTotalExtension(newWidth);
    }
}

