/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.model;

import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.layout.element.PDLElement;
import de.intarsys.pdf.layout.html.model.HtmlBorder;
import de.intarsys.pdf.layout.html.model.HtmlColor;
import de.intarsys.pdf.layout.html.model.TableElement;

public abstract class PDLTableElement
extends PDLElement {
    private TableElement element = null;

    public PDLTableElement(TableElement element) {
        this.element = element;
    }

    protected TableElement getElement() {
        return this.element;
    }

    @Override
    protected float getLocalVerticalSpace() {
        float result = 0.0f;
        result = result + this.getElement().getBottomMargin() + this.getElement().getBottomPadding();
        result = result + this.getElement().getTopMargin() + this.getElement().getTopPadding();
        if (this.getElement().getBorder() != null) {
            result += this.getElement().getBorder().getWidth() * 2.0f;
        }
        return result;
    }

    @Override
    public float getWidth() {
        return this.getElement().getWidth();
    }

    @Override
    public boolean isControlElement() {
        return false;
    }

    @Override
    public boolean isForced() {
        return true;
    }

    @Override
    public boolean isTextElement() {
        return false;
    }

    protected void renderBackground(ICSDevice device) {
        this.renderElementBackground(device, this, this.getMinX(), this.getMinY());
    }

    protected void renderBorder(ICSDevice device) {
        this.renderElementBorder(device, this, this.getMinX(), this.getMinY());
    }

    protected void renderContent(ICSDevice device) {
    }

    protected void renderElementBackground(ICSDevice device, PDLTableElement pde, float offX, float offY) {
        TableElement e = pde.getElement();
        HtmlColor color = e.getBgColor();
        if (color == null) {
            return;
        }
        device.setNonStrokeColorRGB(color.getRed(), color.getGreen(), color.getBlue());
        float borderWidth = 0.0f;
        HtmlBorder border = e.getBorder();
        if (border != null) {
            borderWidth = border.getWidth();
        }
        offX = offX + e.getLeftMargin() + borderWidth / 2.0f;
        offY = offY + e.getBottomMargin() + borderWidth / 2.0f;
        float rectWidth = e.getWidth() - e.getRightMargin() - e.getLeftMargin() - borderWidth;
        float rectHeight = pde.getHeight() - e.getTopMargin() - e.getBottomMargin() - borderWidth;
        device.penRectangle(offX, offY, rectWidth, rectHeight);
        device.pathFillEvenOdd();
    }

    protected void renderElementBorder(ICSDevice device, PDLTableElement pde, float offX, float offY) {
        TableElement e = pde.getElement();
        float borderWidth = 0.0f;
        HtmlBorder b = e.getBorder();
        if (b == null) {
            return;
        }
        HtmlColor color = b.getColor();
        device.setStrokeColorRGB(color.getRed(), color.getGreen(), color.getBlue());
        borderWidth = b.getWidth();
        offX = offX + e.getLeftMargin() + borderWidth / 2.0f;
        offY = offY + e.getBottomMargin() + borderWidth / 2.0f;
        float rectWidth = e.getWidth() - e.getRightMargin() - e.getLeftMargin() - borderWidth;
        float rectHeight = pde.getHeight() - e.getTopMargin() - e.getBottomMargin() - borderWidth;
        device.setLineWidth(borderWidth);
        device.penRectangle(offX, offY, rectWidth, rectHeight);
        device.pathStroke();
    }

    @Override
    public void writeOn(ICSDevice device) {
        super.writeOn(device);
        this.renderBackground(device);
        this.renderBorder(device);
        this.renderContent(device);
    }
}

