/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.model;

import de.intarsys.layout.Aligner;
import de.intarsys.layout.CAxis;
import de.intarsys.layout.CBorderPolicy;
import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.ILayoutContainer;
import de.intarsys.layout.ILayoutVisitor;
import de.intarsys.layout.LayoutContainer;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.layout.element.PDLElement;
import de.intarsys.pdf.layout.html.model.HtmlColor;
import de.intarsys.pdf.layout.html.model.PDLTableCell;
import de.intarsys.pdf.layout.html.model.PDLTableElement;
import de.intarsys.pdf.layout.html.model.Table;
import de.intarsys.pdf.layout.html.model.TableCell;
import de.intarsys.pdf.layout.html.model.TableRow;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class PDLTableRow
extends PDLTableElement {
    private PDLTableRow upper = null;
    private PDLTableRow lower = null;

    public PDLTableRow(TableRow row, ILayoutComponent content) {
        super(row);
        if (content == null) {
            content = new LayoutContainer();
        }
        this.setComponent(content);
    }

    public void addCell(PDLTableCell cell) {
        this.getCells().add((ILayoutComponent)cell);
    }

    public void alignCells() {
        PDLTableCell cell;
        ILayoutComponent c;
        int i;
        Rectangle2D.Double maxRect = new Rectangle2D.Double();
        ILayoutComponent[] children = this.getCells().children();
        for (i = 0; i < children.length; ++i) {
            c = children[i];
            if (!(c instanceof PDLTableCell) || !((double)(cell = (PDLTableCell)c).getContentHeight() > maxRect.height)) continue;
            maxRect.height = cell.getContentHeight();
        }
        for (i = 0; i < children.length; ++i) {
            c = children[i];
            if (!(c instanceof PDLTableCell)) continue;
            cell = (PDLTableCell)c;
            Aligner aligner = cell.createAligner(maxRect);
            aligner.setAxis(CAxis.VERTICAL);
            aligner.setBorderPolicy(CBorderPolicy.FIX);
            aligner.setAlignment(cell.getTableCell().getVAlignment());
            aligner.align();
            cell.moveTo(cell.getMinX(), this.getComponent().getMinY());
        }
    }

    @Override
    protected ILayoutComponent createComponent() {
        return null;
    }

    public LayoutContainer getCells() {
        return (LayoutContainer)this.getComponent();
    }

    protected LayoutContainer getContainer() {
        return (LayoutContainer)this.getComponent();
    }

    @Override
    protected float getLocalVerticalSpace() {
        float result = 0.0f;
        result = this.getTable().getBottomMargin() + this.getTable().getBottomPadding();
        if (this.getTable().getBorder() != null) {
            result += this.getTable().getBorder().getWidth();
        }
        return result;
    }

    public PDLTableRow getLower() {
        return this.lower;
    }

    public PDLTableRow getLowMost() {
        if (this.lower == null) {
            return this;
        }
        return this.lower.getLowMost();
    }

    protected Table getTable() {
        return this.getTableRow().getSegment().getTable();
    }

    protected TableRow getTableRow() {
        return (TableRow)this.getElement();
    }

    public PDLTableRow getUpMost() {
        if (this.upper == null) {
            return this;
        }
        return this.upper.getUpMost();
    }

    public PDLTableRow getUpper() {
        return this.upper;
    }

    public boolean isSplitAllowed() {
        return this.getContainer().isSplitAllowed();
    }

    @Override
    protected void renderBackground(ICSDevice device) {
        Table table = this.getTableRow().getSegment().getTable();
        float pos = table.getLeftMargin();
        if (table.getBorder() != null) {
            pos += table.getBorder().getWidth();
        }
        pos += table.getLeftPadding();
        ILayoutComponent[] children = this.getCells().children();
        for (int i = 0; i < children.length; ++i) {
            ILayoutComponent child = children[i];
            if (!(child instanceof PDLTableCell)) continue;
            PDLTableCell cell = (PDLTableCell)child;
            this.renderElementBackground(device, cell, this.getMinX() + pos, this.getMinY());
            pos += cell.getWidth();
        }
    }

    @Override
    protected void renderBorder(ICSDevice device) {
        Table table = this.getTableRow().getSegment().getTable();
        float pos = table.getLeftMargin();
        if (table.getBorder() != null) {
            pos += table.getBorder().getWidth();
        }
        pos += table.getLeftPadding();
        ILayoutComponent[] children = this.getCells().children();
        for (int i = 0; i < children.length; ++i) {
            ILayoutComponent child = children[i];
            if (!(child instanceof PDLTableCell)) continue;
            PDLTableCell cell = (PDLTableCell)child;
            this.renderElementBorder(device, cell, this.getMinX() + pos, this.getMinY());
            pos += cell.getWidth();
        }
    }

    protected void renderCellContent(final ICSDevice device, PDLTableCell pdeCell, float offX, float offY) {
        TableCell cell = pdeCell.getTableCell();
        offX = offX + cell.getLeftMargin() + cell.getLeftPadding();
        offY = offY + cell.getBottomMargin() + cell.getBottomPadding();
        if (cell.getBorder() != null) {
            offX += cell.getBorder().getWidth();
            offY += cell.getBorder().getWidth();
        }
        pdeCell.moveTo(offX, offY -= cell.getDescent());
        HtmlColor c = cell.getTextColor();
        device.setNonStrokeColorRGB(c.getRed(), c.getGreen(), c.getBlue());
        ILayoutVisitor visitor = new ILayoutVisitor(){

            public Object visitFromLayoutComponent(ILayoutComponent component) {
                if (component instanceof PDLElement) {
                    ((PDLElement)component).writeOn(device);
                }
                return null;
            }

            public Object visitFromLayoutContainer(ILayoutContainer container) {
                ILayoutComponent[] children = container.children();
                for (int i = 0; i < children.length; ++i) {
                    children[i].accept((ILayoutVisitor)this);
                }
                return null;
            }
        };
        pdeCell.getComponent().accept(visitor);
    }

    @Override
    protected void renderContent(ICSDevice device) {
        super.renderContent(device);
        Table table = this.getTableRow().getSegment().getTable();
        float pos = table.getLeftMargin();
        if (table.getBorder() != null) {
            pos += table.getBorder().getWidth();
        }
        pos += table.getLeftPadding();
        ILayoutComponent[] children = this.getCells().children();
        for (int i = 0; i < children.length; ++i) {
            ILayoutComponent child = children[i];
            if (!(child instanceof PDLTableCell)) continue;
            PDLTableCell cell = (PDLTableCell)child;
            this.renderCellContent(device, cell, this.getMinX() + pos, this.getMinY());
            pos += cell.getWidth();
        }
    }

    @Override
    public List splitVertical(float max, boolean reverse) {
        List splitCells = this.getCells().splitVertical(max - this.getLocalVerticalSpace(), reverse);
        if (splitCells == null) {
            return null;
        }
        this.upper = new PDLTableRow(this.getTableRow(), (ILayoutComponent)((LayoutContainer)splitCells.get(0)));
        this.lower = new PDLTableRow(this.getTableRow(), (ILayoutComponent)((LayoutContainer)splitCells.get(1)));
        this.upper.alignCells();
        this.lower.alignCells();
        ArrayList<PDLTableRow> result = new ArrayList<PDLTableRow>();
        result.add(this.upper);
        result.add(this.lower);
        return result;
    }
}

