/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.model;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.LayoutPrimitive;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.layout.html.model.HtmlBorder;
import de.intarsys.pdf.layout.html.model.HtmlColor;
import de.intarsys.pdf.layout.html.model.PDLTableElement;
import de.intarsys.pdf.layout.html.model.PDLTableEnd;
import de.intarsys.pdf.layout.html.model.PDLTableRow;
import de.intarsys.pdf.layout.html.model.TableElement;
import java.util.ArrayList;
import java.util.List;

public class PDLTableStart
extends PDLTableElement {
    private List rows = new ArrayList();
    private final PDLTableEnd end;

    public PDLTableStart(TableElement element) {
        super(element);
        this.end = new PDLTableEnd(element);
    }

    public void addRow(PDLTableRow row) {
        this.rows.add(row);
    }

    @Override
    protected ILayoutComponent createComponent() {
        return new LayoutPrimitive(0.0f, 0.0f);
    }

    public PDLTableEnd getEnd() {
        return this.end;
    }

    @Override
    public float getHeight() {
        float result = this.getElement().getTopMargin() + this.getElement().getTopPadding();
        if (this.getElement().getBorder() != null) {
            result += this.getElement().getBorder().getWidth();
        }
        return result;
    }

    protected List getRows() {
        return this.rows;
    }

    @Override
    protected void renderBackground(ICSDevice device) {
        HtmlColor b = this.getElement().getBgColor();
        if (b == null) {
            return;
        }
        device.setNonStrokeColorRGB(b.getRed(), b.getGreen(), b.getBlue());
        float llX = this.getMinX() + this.getElement().getLeftMargin();
        float width = this.getWidth() - this.getElement().getRightMargin() - this.getElement().getLeftMargin();
        float height = this.getHeight();
        for (PDLTableRow row : this.getRows()) {
            height += row.getHeight();
        }
        float llY = this.getMinY() + this.getHeight() - (height += this.getEnd().getHeight()) + this.getElement().getBottomMargin();
        height = height - this.getElement().getBottomMargin() - this.getElement().getTopMargin();
        device.penRectangle(llX, llY, width, height);
        device.pathFillEvenOdd();
    }

    @Override
    protected void renderBorder(ICSDevice device) {
        HtmlBorder b = this.getElement().getBorder();
        if (b == null) {
            return;
        }
        HtmlColor color = b.getColor();
        device.setStrokeColorRGB(color.getRed(), color.getGreen(), color.getBlue());
        float halfBorder = b.getWidth() / 2.0f;
        float llX = this.getMinX() + this.getElement().getLeftMargin() + halfBorder;
        float width = this.getWidth() - this.getElement().getRightMargin() - this.getElement().getLeftMargin() - halfBorder - halfBorder;
        float height = this.getHeight();
        for (PDLTableRow row : this.getRows()) {
            height += row.getHeight();
        }
        float llY = this.getMinY() + this.getHeight() - (height += this.getEnd().getHeight()) + this.getElement().getBottomMargin() + halfBorder;
        height = height - this.getElement().getBottomMargin() - this.getElement().getTopMargin() - halfBorder - halfBorder;
        device.setLineWidth(b.getWidth());
        device.penRectangle(llX, llY, width, height);
        device.pathStroke();
    }

    @Override
    protected void renderContent(ICSDevice device) {
    }
}

