/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.model;

import de.intarsys.pdf.layout.html.model.ITableVisitor;
import de.intarsys.pdf.layout.html.model.Table;
import de.intarsys.pdf.layout.html.model.TableBody;
import de.intarsys.pdf.layout.html.model.TableCell;
import de.intarsys.pdf.layout.html.model.TableColumn;
import de.intarsys.pdf.layout.html.model.TableFooter;
import de.intarsys.pdf.layout.html.model.TableHeader;
import de.intarsys.pdf.layout.html.model.TableRow;

public class SimpleTableDumper
implements ITableVisitor {
    @Override
    public Object visitFromTable(Table table) throws Exception {
        table.getHeader().accept(this);
        table.getBody().accept(this);
        table.getFooter().accept(this);
        return null;
    }

    @Override
    public Object visitFromTableBody(TableBody body) throws Exception {
        for (TableRow row : body.getRows()) {
            row.accept(this);
        }
        return null;
    }

    @Override
    public Object visitFromTableCell(TableCell cell) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("| ");
        String content = cell.toString();
        int width = (int)cell.getColumnWidth();
        if (width < content.length()) {
            if (width > 0) {
                sb.append(content.substring(0, width));
            }
        } else {
            sb.append(content);
            for (int i = content.length(); i < width; ++i) {
                sb.append(" ");
            }
        }
        sb.append(" ");
        System.out.print(sb.toString());
        return sb.toString();
    }

    @Override
    public Object visitFromTableFooter(TableFooter footer) throws Exception {
        for (TableRow row : footer.getRows()) {
            row.accept(this);
        }
        return null;
    }

    @Override
    public Object visitFromTableHeader(TableHeader header) throws Exception {
        for (TableRow row : header.getRows()) {
            row.accept(this);
        }
        return null;
    }

    @Override
    public Object visitFromTableRow(TableRow row) throws Exception {
        for (TableColumn column : row.getSegment().getTable().getColumns()) {
            System.out.print("+-");
            for (int i = (int)column.getWidth(); i > 0; --i) {
                System.out.print("-");
            }
            System.out.print("-");
        }
        System.out.println("+");
        for (TableCell cell : row.getCells()) {
            cell.accept(this);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("|");
        System.out.println(sb.toString());
        return null;
    }
}

