/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.model;

import de.intarsys.pdf.layout.html.model.Extension;
import de.intarsys.pdf.layout.html.model.HorizontalExtension;
import de.intarsys.pdf.layout.html.model.HtmlElement;
import de.intarsys.pdf.layout.html.model.ITableVisitor;
import de.intarsys.pdf.layout.html.model.TableBody;
import de.intarsys.pdf.layout.html.model.TableColumn;
import de.intarsys.pdf.layout.html.model.TableColumnsWidthFunctor;
import de.intarsys.pdf.layout.html.model.TableElement;
import de.intarsys.pdf.layout.html.model.TableFooter;
import de.intarsys.pdf.layout.html.model.TableHeader;
import de.intarsys.pdf.layout.html.model.TableRow;
import de.intarsys.pdf.layout.html.model.VerticalExtension;
import java.util.ArrayList;
import java.util.List;

public class Table
extends TableElement {
    private Extension cellHorizontalExtension;
    private Extension cellVerticalExtension;
    private List columns = new ArrayList();
    private TableBody body = new TableBody(this);
    private TableFooter footer = new TableFooter(this);
    private TableHeader header = new TableHeader(this);
    private float cellpadding = Float.NaN;
    private float cellspacing = Float.NaN;

    public Table(HtmlElement parent) {
        super(parent);
        this.getHorizontalExtension().setExtensionFunctor(TableColumnsWidthFunctor.UNIQUE);
        this.getHorizontalExtension().setLowerPadding(this.getCellspacing());
        this.getVerticalExtension().setLowerPadding(this.getCellspacing());
    }

    @Override
    public Object accept(ITableVisitor visitor) throws Exception {
        return visitor.visitFromTable(this);
    }

    public void defineCellpadding(String definition) {
        if (definition == null) {
            return;
        }
        if (definition.trim().length() == 0 || definition.equals("#DEFAULT")) {
            this.setCellpadding(Float.NaN);
        } else {
            try {
                this.setCellpadding(Float.parseFloat(definition));
            }
            catch (NumberFormatException e) {
                this.setCellpadding(Float.NaN);
            }
        }
    }

    public void defineCellspacing(String definition) {
        if (definition == null) {
            return;
        }
        if (definition.trim().length() == 0 || definition.equals("#DEFAULT")) {
            this.setCellspacing(Float.NaN);
        } else {
            try {
                this.setCellspacing(Float.parseFloat(definition));
            }
            catch (NumberFormatException e) {
                this.setCellspacing(Float.NaN);
            }
        }
    }

    public TableBody getBody() {
        return this.body;
    }

    public Extension getCellHorizontalExtension() {
        if (this.cellHorizontalExtension == null) {
            this.cellHorizontalExtension = new HorizontalExtension(null);
            this.cellHorizontalExtension.setLowerMargin(0.0f);
            this.cellHorizontalExtension.setLowerPadding(this.getCellpadding());
            this.cellHorizontalExtension.setUpperPadding(this.getCellpadding());
            this.cellHorizontalExtension.setUpperMargin(this.getCellspacing());
        }
        return this.cellHorizontalExtension;
    }

    public float getCellpadding() {
        if (Table.isDefault(this.cellpadding)) {
            return 2.0f;
        }
        return this.cellpadding;
    }

    public float getCellspacing() {
        if (Table.isDefault(this.cellspacing)) {
            return 2.0f;
        }
        return this.cellspacing;
    }

    public Extension getCellVerticalExtension() {
        if (this.cellVerticalExtension == null) {
            this.cellVerticalExtension = new VerticalExtension(null);
            this.cellVerticalExtension.setLowerMargin(0.0f);
            this.cellVerticalExtension.setLowerPadding(this.getCellpadding());
            this.cellVerticalExtension.setUpperPadding(this.getCellpadding());
            this.cellVerticalExtension.setUpperMargin(this.getCellspacing());
        }
        return this.cellVerticalExtension;
    }

    public TableColumn getColumn(int index) {
        if (index >= this.getColumns().size()) {
            new TableColumn(this);
            return this.getColumn(index);
        }
        return (TableColumn)this.getColumns().get(index);
    }

    public List getColumns() {
        return this.columns;
    }

    @Override
    public float getContentHeight() {
        float result = 0.0f;
        for (TableRow tr : this.getHeader().getRows()) {
            result += tr.getHeight();
        }
        for (TableRow tr : this.getBody().getRows()) {
            result += tr.getHeight();
        }
        for (TableRow tr : this.getFooter().getRows()) {
            result += tr.getHeight();
        }
        return result;
    }

    public TableFooter getFooter() {
        return this.footer;
    }

    public TableHeader getHeader() {
        return this.header;
    }

    public boolean isEmpty() {
        return this.getBody().isEmpty();
    }

    protected void setBody(TableBody body) {
        this.body = body;
    }

    public void setCellpadding(float cellpadding) {
        this.cellpadding = cellpadding;
    }

    public void setCellspacing(float cellspacing) {
        this.cellspacing = cellspacing;
        this.getHorizontalExtension().setLowerPadding(cellspacing);
        this.getVerticalExtension().setLowerPadding(cellspacing);
    }

    protected void setFooter(TableFooter footer) {
        this.footer = footer;
    }

    protected void setHeader(TableHeader header) {
        this.header = header;
    }
}

