/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.model;

import de.intarsys.layout.CAlignment;
import de.intarsys.pdf.layout.html.model.ColumnDefaultHeightFunctor;
import de.intarsys.pdf.layout.html.model.ColumnDefaultWidthFunctor;
import de.intarsys.pdf.layout.html.model.HtmlBorder;
import de.intarsys.pdf.layout.html.model.HtmlColor;
import de.intarsys.pdf.layout.html.model.ITableVisitor;
import de.intarsys.pdf.layout.html.model.TableColumn;
import de.intarsys.pdf.layout.html.model.TableElement;
import de.intarsys.pdf.layout.html.model.TableRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableCell
extends TableElement {
    private Map attributes = new HashMap();
    private List<TableColumn> columns = new ArrayList<TableColumn>();
    private int hSpan = 1;

    public TableCell(TableRow parent) {
        this(parent, 1);
    }

    public TableCell(TableRow parent, int hSpan) {
        super(parent);
        this.hSpan = hSpan;
        parent.addCell(this);
        this.getHorizontalExtension().setExtensionFunctor(ColumnDefaultWidthFunctor.UNIQUE);
        this.getVerticalExtension().setExtensionFunctor(ColumnDefaultHeightFunctor.UNIQUE);
        this.getVerticalExtension().setDefaultExtension(parent.getSegment().getTable().getCellVerticalExtension());
        this.getHorizontalExtension().setDefaultExtension(parent.getSegment().getTable().getCellHorizontalExtension());
    }

    @Override
    public Object accept(ITableVisitor visitor) throws Exception {
        return visitor.visitFromTableCell(this);
    }

    protected void addColumn(TableColumn columnDescriptor) {
        this.columns.add(columnDescriptor);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public float getColumnContentWidth() {
        float result = 0.0f;
        for (TableColumn column : this.getColumns()) {
            result += column.getContentWidth();
        }
        return result;
    }

    public List<TableColumn> getColumns() {
        return this.columns;
    }

    public float getColumnWidth() {
        float result = 0.0f;
        for (TableColumn column : this.getColumns()) {
            result += column.getWidth();
        }
        return result;
    }

    @Override
    protected HtmlColor getDefaultBgColor() {
        return this.getParent().getBgColor();
    }

    @Override
    protected HtmlBorder getDefaultBorder() {
        if (this.getFirstColumn().getTable().getBorder() != null) {
            HtmlBorder newBorder = new HtmlBorder();
            float newWidth = Math.min(this.getFirstColumn().getTable().getBorder().getWidth(), HtmlBorder.DEFAULT_WIDTH);
            newBorder.setWidth(newWidth);
            return newBorder;
        }
        return super.getDefaultBorder();
    }

    public TableColumn getFirstColumn() {
        return this.getColumns().get(0);
    }

    @Override
    public String getFont() {
        if (super.getFont() == null) {
            return this.getRow().getFont();
        }
        return super.getFont();
    }

    @Override
    public float getFontSize() {
        if (super.getFontSize() == 0.0f) {
            return this.getRow().getFontSize();
        }
        return super.getFontSize();
    }

    @Override
    public int getHAlignment() {
        int result = super.getHAlignment();
        if (result == CAlignment.UNDEFINED) {
            result = this.getFirstColumn().getHAlignment();
        }
        if (result == CAlignment.UNDEFINED) {
            result = this.getRow().getHAlignment();
        }
        if (result == CAlignment.UNDEFINED) {
            result = CAlignment.LEFT;
        }
        return result;
    }

    public int getHSpan() {
        return this.hSpan;
    }

    public TableRow getRow() {
        return (TableRow)this.getParent();
    }

    @Override
    public HtmlColor getTextColor() {
        if (super.getTextColor() == null) {
            return this.getRow().getTextColor();
        }
        return super.getTextColor();
    }

    @Override
    public int getVAlignment() {
        int result = super.getVAlignment();
        if (result == CAlignment.UNDEFINED) {
            result = this.getFirstColumn().getVAlignment();
        }
        if (result == CAlignment.UNDEFINED) {
            result = this.getRow().getVAlignment();
        }
        if (result == CAlignment.UNDEFINED) {
            result = CAlignment.TOP;
        }
        return result;
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public void setContentHeight(float contentHeight) {
        super.setContentHeight(contentHeight);
        this.setHeight(this.getHeight());
    }

    @Override
    public void setContentWidth(float contentWidth) {
        super.setContentWidth(contentWidth);
        this.setWidth(this.getWidth());
    }

    @Override
    public void setHeight(float height) {
        super.setHeight(Float.NaN);
        this.getVerticalExtension().setExtensionFunctor(ColumnDefaultHeightFunctor.UNIQUE);
        float currentHeight = this.getRow().getHeight();
        this.getRow().setHeight(Math.max(currentHeight, height));
    }

    @Override
    public void setWidth(float width) {
        super.setWidth(Float.NaN);
        this.getHorizontalExtension().setExtensionFunctor(ColumnDefaultWidthFunctor.UNIQUE);
        float currentWidth = this.getFirstColumn().getWidth();
        this.getFirstColumn().setWidth(Math.max(currentWidth, width));
    }
}

