/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.model;

import de.intarsys.layout.CAlignment;
import de.intarsys.pdf.layout.html.model.HtmlColor;
import de.intarsys.pdf.layout.html.model.HtmlElement;
import de.intarsys.pdf.layout.html.model.ITableVisitor;

public abstract class TableElement
extends HtmlElement {
    private HtmlColor textColor = HtmlColor.BLACK;
    private String font;
    private float fontSize = 0.0f;
    private int hAlignment = CAlignment.UNDEFINED;
    private int vAlignment = CAlignment.UNDEFINED;

    public TableElement(HtmlElement parent) {
        super(parent);
    }

    public abstract Object accept(ITableVisitor var1) throws Exception;

    public void defineAlign(String definition) {
        if (definition == null) {
            return;
        }
        if (definition.equals("left") || definition.equals("start")) {
            this.setHAlignment(CAlignment.LEFT);
        }
        if (definition.equals("center")) {
            this.setHAlignment(CAlignment.CENTER);
        }
        if (definition.equals("right") || definition.equals("end")) {
            this.setHAlignment(CAlignment.RIGHT);
        }
        if (definition.equals("justify")) {
            this.setHAlignment(CAlignment.JUSTIFY);
        }
    }

    public void defineVAlign(String definition) {
        if (definition == null) {
            return;
        }
        if (definition.equals("top") || definition.equals("end")) {
            this.setVAlignment(CAlignment.TOP);
        }
        if (definition.equals("middle")) {
            this.setVAlignment(CAlignment.CENTER);
        }
        if (definition.equals("center")) {
            this.setVAlignment(CAlignment.CENTER);
        }
        if (definition.equals("bottom") || definition.equals("start")) {
            this.setVAlignment(CAlignment.BOTTOM);
        }
        if (definition.equals("justify")) {
            this.setVAlignment(CAlignment.JUSTIFY);
        }
    }

    @Override
    protected HtmlColor getDefaultBgColor() {
        return null;
    }

    public String getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public int getHAlignment() {
        return this.hAlignment;
    }

    public HtmlColor getTextColor() {
        return this.textColor;
    }

    public int getVAlignment() {
        return this.vAlignment;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public void setHAlignment(int alignment) {
        this.hAlignment = alignment;
    }

    public void setTextColor(HtmlColor textColor) {
        if (textColor == null) {
            throw new IllegalArgumentException("color may not be null");
        }
        this.textColor = textColor;
    }

    public void setVAlignment(int alignment) {
        this.vAlignment = alignment;
    }
}

