/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.parser;

import de.intarsys.html.IStyle;
import java.util.List;

public class CSSFontDefinition {
    private String fontStyle = null;
    private String fontVariant = null;
    private String fontWeight = null;
    private String fontSize = null;
    private String lineHeight = null;
    private String fontFamily = null;

    public static CSSFontDefinition createFromStyle(IStyle style) {
        CSSFontDefinition result = new CSSFontDefinition();
        List fontProperties = style.getPropertyValues("font");
        for (String value : fontProperties) {
            if (result.getFontStyle() == null && CSSFontDefinition.mayBeFontStyle(value)) {
                result.setFontStyle(value);
                continue;
            }
            if (result.getFontVariant() == null && CSSFontDefinition.mayBeFontVariant(value)) {
                result.setFontVariant(value);
                continue;
            }
            if (result.getFontWeight() == null && CSSFontDefinition.mayBeFontWeight(value)) {
                result.setFontWeight(value);
                continue;
            }
            if (result.getFontSize() == null && CSSFontDefinition.mayBeFontSize(value)) {
                result.setFontSize(value);
                continue;
            }
            if (result.getLineHeight() == null && CSSFontDefinition.mayBeLineHeight(value)) {
                result.setLineHeight(value);
                continue;
            }
            if (result.getFontFamily() != null || !CSSFontDefinition.mayBeFontFamily(value)) continue;
            result.setFontFamily(value);
        }
        String value = style.getPropertyValue("font-family");
        if (value != null) {
            result.setFontFamily(value);
        }
        if ((value = style.getPropertyValue("font-size")) != null) {
            result.setFontSize(value);
        }
        if ((value = style.getPropertyValue("font-style")) != null) {
            result.setFontStyle(value);
        }
        if ((value = style.getPropertyValue("font-weight")) != null) {
            result.setFontWeight(value);
        }
        return result;
    }

    protected static boolean mayBeFontFamily(String value) {
        return true;
    }

    protected static boolean mayBeFontSize(String value) {
        return true;
    }

    protected static boolean mayBeFontStyle(String value) {
        return "italic".equalsIgnoreCase(value) || "normal".equalsIgnoreCase(value) || "oblique".equalsIgnoreCase(value);
    }

    protected static boolean mayBeFontVariant(String value) {
        return "small-caps".equalsIgnoreCase(value) || "normal".equalsIgnoreCase(value);
    }

    protected static boolean mayBeFontWeight(String value) {
        return "bold".equalsIgnoreCase(value) || "normal".equalsIgnoreCase(value);
    }

    protected static boolean mayBeLineHeight(String value) {
        return true;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public String getFontVariant() {
        return this.fontVariant;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public String getLineHeight() {
        return this.lineHeight;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setFontVariant(String fontVariant) {
        this.fontVariant = fontVariant;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public void setLineHeight(String lineHeight) {
        this.lineHeight = lineHeight;
    }
}

