/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.parser;

import de.intarsys.layout.CAlignment;

public class CSSPosition {
    public static final String POSITION_CENTER = "center";
    public static final String POSITION_TOP = "top";
    public static final String POSITION_BOTTOM = "bottom";
    public static final String POSITION_LEFT = "left";
    public static final String POSITION_RIGHT = "right";
    private int ver = CAlignment.UNDEFINED;
    private int hor = CAlignment.UNDEFINED;

    public static int parseAlignment(String alignment) {
        if (alignment.equalsIgnoreCase(POSITION_TOP)) {
            return CAlignment.TOP;
        }
        if (alignment.equalsIgnoreCase(POSITION_BOTTOM)) {
            return CAlignment.BOTTOM;
        }
        if (alignment.equalsIgnoreCase(POSITION_CENTER)) {
            return CAlignment.CENTER;
        }
        if (alignment.equalsIgnoreCase(POSITION_LEFT)) {
            return CAlignment.LEFT;
        }
        if (alignment.equalsIgnoreCase(POSITION_RIGHT)) {
            return CAlignment.RIGHT;
        }
        return CAlignment.UNDEFINED;
    }

    public CSSPosition(String position) {
        this.setPosition(position);
    }

    public int getHor() {
        return this.hor;
    }

    public int getVer() {
        return this.ver;
    }

    private void setPosition(String position) {
        this.ver = CAlignment.UNDEFINED;
        this.hor = CAlignment.UNDEFINED;
        if (position != null && position != "") {
            if ((position = position.trim()).equalsIgnoreCase(POSITION_CENTER)) {
                this.hor = CAlignment.CENTER;
                this.ver = CAlignment.CENTER;
            } else {
                int p = position.indexOf(" ");
                if (p > 0) {
                    String h = position.substring(0, p);
                    String v = position.substring(p + 1);
                    this.hor = CSSPosition.parseAlignment(h);
                    this.ver = CSSPosition.parseAlignment(v);
                }
            }
        }
    }
}

