/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.parser;

import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.font.outlet.FontQuery;
import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.font.outlet.IFontQuery;
import de.intarsys.tools.string.StringTools;
import java.util.StringTokenizer;

public final class PDLCssTools {
    public static float[] getColor(String colorDefinition) {
        if (colorDefinition == null) {
            return null;
        }
        float[] result = null;
        result = colorDefinition.startsWith("#") ? PDLCssTools.parseColorHex(colorDefinition.substring(1)) : (colorDefinition.startsWith("rgb(") ? PDLCssTools.parseColorRGB(colorDefinition.substring(4, colorDefinition.length() - 1)) : PDLCssTools.parseColorPredefined(colorDefinition));
        return result;
    }

    public static PDFont getFont(IFontFactory factory, PDFont previous, String fontDefinition) {
        StringTokenizer st = new StringTokenizer(fontDefinition, ",");
        while (st.hasMoreTokens()) {
            String currentDefinition = st.nextToken().trim();
            if (currentDefinition.startsWith("\"") && currentDefinition.endsWith("\"") || currentDefinition.startsWith("'") && currentDefinition.endsWith("'")) {
                currentDefinition = currentDefinition.substring(1, currentDefinition.length() - 1);
            }
            FontQuery template = new FontQuery();
            template.setOverrideFontType("Any");
            template.setOverrideFontName(currentDefinition);
            template.setOverrideFontFamilyName(currentDefinition);
            template.setOverrideFontStyle(PDFontStyle.REGULAR);
            try {
                PDFont newFont = factory.getFont((IFontQuery)template);
                if (newFont == null) continue;
                return newFont;
            }
            catch (FontFactoryException fontFactoryException) {
            }
        }
        return previous;
    }

    public static float getFontSize(float oldSize, String sizeDefinition) {
        if (sizeDefinition == null) {
            return oldSize;
        }
        if ((sizeDefinition = sizeDefinition.trim()).equals("xx-small")) {
            return 6.0f;
        }
        if (sizeDefinition.equals("x-small")) {
            return 8.0f;
        }
        if (sizeDefinition.equals("small")) {
            return 10.0f;
        }
        if (sizeDefinition.equals("medium")) {
            return 12.0f;
        }
        if (sizeDefinition.equals("large")) {
            return 14.0f;
        }
        if (sizeDefinition.equals("x-large")) {
            return 16.0f;
        }
        if (sizeDefinition.equals("xx-large")) {
            return 18.0f;
        }
        if (sizeDefinition.equals("smaller")) {
            return oldSize - 2.0f;
        }
        if (sizeDefinition.equals("larger")) {
            return oldSize + 2.0f;
        }
        return PDLCssTools.getSize(oldSize, sizeDefinition);
    }

    public static float getSize(float oldSize, String sizeDefinition) {
        StringBuffer sb = new StringBuffer();
        String sizeUnit = null;
        for (int i = 0; i < sizeDefinition.length(); ++i) {
            char current = sizeDefinition.charAt(i);
            if (!Character.isDigit(current) && current != '.') {
                sizeUnit = sizeDefinition.substring(i);
                break;
            }
            sb.append(current);
        }
        String sizeNumber = sb.toString();
        float size = Float.parseFloat(sizeNumber);
        if (sizeUnit == null) {
            size = Float.parseFloat(sizeNumber);
        } else if ("pt".equalsIgnoreCase(sizeUnit)) {
            size = Float.parseFloat(sizeNumber);
        } else if ("pc".equalsIgnoreCase(sizeUnit)) {
            size = Float.parseFloat(sizeNumber) * 12.0f;
        } else if ("in".equalsIgnoreCase(sizeUnit)) {
            size = Float.parseFloat(sizeNumber) * 72.0f;
        } else if ("mm".equalsIgnoreCase(sizeUnit)) {
            size = Float.parseFloat(sizeNumber) * 72.0f / 25.4f;
        } else if ("cm".equalsIgnoreCase(sizeUnit)) {
            size = Float.parseFloat(sizeNumber) * 72.0f / 2.54f;
        } else if ("px".equalsIgnoreCase(sizeUnit)) {
            size = Float.parseFloat(sizeNumber);
        } else if ("em".equalsIgnoreCase(sizeUnit)) {
            size = Float.parseFloat(sizeNumber) * oldSize;
        } else if ("ex".equalsIgnoreCase(sizeUnit)) {
            size = Float.parseFloat(sizeNumber) * oldSize;
        } else if ("%".equalsIgnoreCase(sizeUnit)) {
            size = Float.parseFloat(sizeNumber) * oldSize / 100.0f;
        }
        return size;
    }

    public static float getSize(String sizeDefinition) {
        return PDLCssTools.getSize(0.0f, sizeDefinition);
    }

    protected static float[] parseColorHex(String definition) {
        Object r = null;
        Object g = null;
        Object b = null;
        if (definition.length() == 3) {
            r = definition.substring(0, 1);
            r = (String)r + (String)r;
            g = definition.substring(1, 2);
            g = (String)g + (String)g;
            b = definition.substring(2, 3);
            b = (String)b + (String)b;
        } else {
            r = definition.substring(0, 2);
            g = definition.substring(2, 4);
            b = definition.substring(4, 6);
        }
        float[] result = new float[]{(float)Integer.parseInt((String)r, 16) / 255.0f, (float)Integer.parseInt((String)g, 16) / 255.0f, (float)Integer.parseInt((String)b, 16) / 255.0f};
        return result;
    }

    protected static float[] parseColorPredefined(String definition) {
        if ("red".equalsIgnoreCase(definition)) {
            return new float[]{1.0f, 0.0f, 0.0f};
        }
        if ("green".equalsIgnoreCase(definition)) {
            return new float[]{0.0f, 0.5f, 0.0f};
        }
        if ("blue".equalsIgnoreCase(definition)) {
            return new float[]{0.0f, 0.0f, 1.0f};
        }
        if ("lime".equalsIgnoreCase(definition)) {
            return new float[]{0.0f, 1.0f, 0.0f};
        }
        if ("black".equalsIgnoreCase(definition)) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        if ("white".equalsIgnoreCase(definition)) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        if ("yellow".equalsIgnoreCase(definition)) {
            return new float[]{1.0f, 1.0f, 0.0f};
        }
        if ("fuchsia".equalsIgnoreCase(definition)) {
            return new float[]{1.0f, 0.0f, 1.0f};
        }
        if ("aqua".equalsIgnoreCase(definition)) {
            return new float[]{0.0f, 1.0f, 1.0f};
        }
        if ("gray".equalsIgnoreCase(definition)) {
            return new float[]{0.5f, 0.5f, 0.5f};
        }
        if ("grey".equalsIgnoreCase(definition)) {
            return new float[]{0.5f, 0.5f, 0.5f};
        }
        if ("maroon".equalsIgnoreCase(definition)) {
            return new float[]{0.5f, 0.0f, 0.0f};
        }
        if ("olive".equalsIgnoreCase(definition)) {
            return new float[]{0.5f, 0.5f, 0.0f};
        }
        if ("navy".equalsIgnoreCase(definition)) {
            return new float[]{0.0f, 0.0f, 0.5f};
        }
        if ("purple".equalsIgnoreCase(definition)) {
            return new float[]{0.5f, 0.0f, 0.5f};
        }
        if ("teal".equalsIgnoreCase(definition)) {
            return new float[]{0.0f, 0.5f, 0.5f};
        }
        if ("silver".equalsIgnoreCase(definition)) {
            return new float[0];
        }
        return null;
    }

    protected static float[] parseColorRGB(String definition) {
        float[] result = new float[3];
        StringTokenizer tk = new StringTokenizer(definition, ",");
        for (int index = 0; tk.hasMoreTokens() && index < 3; ++index) {
            String t = tk.nextToken().trim();
            result[index] = t.endsWith("%") ? Float.parseFloat(t.substring(0, t.length() - 1)) / 100.0f : Float.parseFloat(t) / 255.0f;
        }
        return result;
    }

    public static float parseMargin(double oldSize, String marginString) {
        if (StringTools.isEmpty((String)marginString)) {
            return 0.0f;
        }
        Float f = Float.valueOf(0.0f);
        try {
            f = Float.valueOf(PDLCssTools.getSize((float)oldSize, marginString));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return f.floatValue();
    }

    private PDLCssTools() {
    }
}

