/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.parser;

import de.intarsys.html.IHtmlTag;
import de.intarsys.html.IHtmlTagImpl;
import de.intarsys.html.IHtmlTagImplFactory;
import de.intarsys.html.impl.AbstractHtmlHandler;
import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.layout.html.parser.PDLTextHtmlParser;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagFactory;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagRoot;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.pdf.layout.parser.PDLParseException;
import java.util.Iterator;
import java.util.List;

public class PDLHtmlHandler
extends AbstractHtmlHandler {
    private PDLTextHtmlParser parser;
    private PDLTextFormat textFormat = null;

    public PDLHtmlHandler(PDLTextHtmlParser parser) {
        super((IHtmlTagImplFactory)PDLHtmlTagFactory.getActive());
        this.parser = parser;
    }

    protected IHtmlTagImpl createRootElement() throws Exception {
        return new PDLHtmlTagRoot(this);
    }

    public void endTag(IHtmlTag tag) throws Exception {
        this.getPDEParser().flush();
        this.getCurrentTag().ended();
        IHtmlTagImpl oldTag = (IHtmlTagImpl)this.getTagStack().pop();
        this.getCurrentTag().end(oldTag);
    }

    public IPDLTextPad getActivePad() {
        return this.getCurrentPDETag().getActivePad();
    }

    protected PDLHtmlTag getCurrentPDETag() {
        return (PDLHtmlTag)this.getCurrentTag();
    }

    public IFontFactory getFontFactory() {
        return this.getPDEParser().getFontFactory();
    }

    public IPDLTextPad getPad() {
        return this.getPDEParser().getPad();
    }

    public PDLTextHtmlParser getPDEParser() {
        return this.parser;
    }

    protected PDLTextFormat getTextFormat() {
        return this.textFormat;
    }

    public void handleOverflow(List overflow) throws PDLParseException {
        for (PDLHtmlTag tag = this.getCurrentPDETag(); tag != null; tag = (PDLHtmlTag)tag.getParent()) {
            tag.handleOverflow(overflow);
        }
    }

    public void replayOverflow(List overflow) throws PDLParseException {
        for (PDLHtmlTag tag : this.getTagStack()) {
            tag.replayOverflow(overflow);
        }
    }

    public void setPad(IPDLTextPad pad) {
        PDLHtmlTag tag;
        Iterator it = this.getTagStack().iterator();
        while (it.hasNext() && !(tag = (PDLHtmlTag)((Object)it.next())).isCreateNewPad()) {
            tag.startedPad();
        }
        if (this.getTextFormat() != null) {
            this.setTextFormat(this.getTextFormat());
        }
    }

    public void setTextFormat(PDLTextFormat textState) {
        this.textFormat = textState;
        IPDLTextPad pad = this.getPad();
        if (pad == null) {
            return;
        }
        pad.setTextFormat(textState);
        for (PDLHtmlTag tag : this.getTagStack()) {
            IPDLTextPad currentPad;
            PDLTextFormat newTextState = tag.startedCustomizeTextFormat(pad);
            if (newTextState != pad.getTextFormat()) {
                tag.setPreviousTextFormat(pad.getTextFormat());
            }
            pad = (currentPad = tag.getLocalPad()) == null ? pad : currentPad;
            pad.setTextFormat(newTextState);
        }
    }

    public void startTag(IHtmlTag tag) throws Exception {
        IHtmlTagImpl newTag = this.getCurrentTag().start(tag);
        this.getTagStack().push(newTag);
        this.getPDEParser().flush();
        this.getCurrentTag().started();
    }
}

