/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.parser;

import de.intarsys.html.CompositeStyle;
import de.intarsys.html.IHtmlHandler;
import de.intarsys.html.IHtmlTag;
import de.intarsys.html.IHtmlTagImpl;
import de.intarsys.html.IStyle;
import de.intarsys.html.IStyleSheet;
import de.intarsys.html.IStyleSheetParser;
import de.intarsys.html.NullStyle;
import de.intarsys.html.impl.AbstractHtmlTagImpl;
import de.intarsys.layout.CAlignment;
import de.intarsys.layout.CBorderPolicy;
import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.ILayoutContainer;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.layout.html.model.HtmlElement;
import de.intarsys.pdf.layout.html.model.TableSegment;
import de.intarsys.pdf.layout.html.parser.CSSFontDefinition;
import de.intarsys.pdf.layout.html.parser.PDLCssTools;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLTextHtmlParser;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLLayouter;
import de.intarsys.pdf.layout.pad.PDLParagraphFormat;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.pdf.layout.pad.PDLTextPad;
import de.intarsys.pdf.layout.parser.PDLParseException;
import java.awt.geom.Rectangle2D;
import java.io.CharArrayReader;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PDLHtmlTag
extends AbstractHtmlTagImpl {
    private IStyle style;
    private final HtmlElement htmlElement;
    private IPDLTextPad localPad = null;
    private PDLLayouter previousLayouter = null;
    private PDLParagraphFormat previousParagraphFormat = null;
    private PDLTextFormat previousTextFormat = null;

    public static int convertAttributeHAlign(String attribute) {
        if (attribute == null) {
            return -1;
        }
        int align = CAlignment.LEFT;
        if ("left".equals(attribute) || "start".equals(attribute)) {
            align = CAlignment.LEFT;
        }
        if ("center".equals(attribute)) {
            align = CAlignment.CENTER;
        }
        if ("right".equals(attribute) || "end".equals(attribute)) {
            align = CAlignment.RIGHT;
        }
        if ("justify".equals(attribute)) {
            align = CAlignment.JUSTIFY;
        }
        return align;
    }

    protected PDLHtmlTag(PDLHtmlHandler handler, PDLHtmlTag parent, IHtmlTag htmlTag, HtmlElement htmlElement) {
        super((IHtmlHandler)handler, (IHtmlTagImpl)parent, htmlTag);
        this.htmlElement = htmlElement;
    }

    public void end(IHtmlTagImpl pdeTag) throws PDLParseException {
    }

    public void endCurrentLine(boolean hasHeight) throws PDLParseException {
        this.getPDEParser().endCurrentLine(hasHeight);
    }

    public void ended() throws PDLParseException {
        String breakAfter = this.getStyle().getPropertyValue("page-break-after");
        if ("always".equalsIgnoreCase(breakAfter)) {
            this.newPage();
        }
        if (this.isParagraph()) {
            this.newParagraph();
        } else if (this.isBreak()) {
            this.newLine(false);
        }
        this.endedPad();
    }

    protected PDLLayouter endedCustomizeLayouter(IPDLTextPad pad) {
        PDLLayouter result = this.getPreviousLayouter();
        if (result != null) {
            Rectangle2D previousBBox = result.getBoundingBox();
            Rectangle2D currentLBox = pad.getLayoutContainer().getBoundingBox();
            float newMinX = (float)previousBBox.getMinX();
            float newMinY = (float)previousBBox.getMinY();
            float newWidth = (float)previousBBox.getWidth();
            float newHeight = (float)currentLBox.getMinY() - newMinY;
            Rectangle2D.Float newRect = new Rectangle2D.Float(newMinX, newMinY, newWidth, newHeight);
            result = new PDLLayouter(newRect);
        }
        return result;
    }

    protected PDLParagraphFormat endedCustomizeParagraphFormat(IPDLTextPad pad) {
        return this.getPreviousParagraphFormat();
    }

    protected PDLTextFormat endedCustomizeTextFormat(IPDLTextPad pad) {
        return this.getPreviousTextFormat();
    }

    protected final void endedPad() throws PDLParseException {
        IPDLTextPad pad = this.getLocalPad();
        if (pad != null) {
            this.setLocalPad(null);
            pad.close();
            ILayoutContainer component = pad.getLayoutContainer();
            this.getActivePad().layoutElement((ILayoutComponent)component);
            this.endCurrentLine(false);
        } else {
            PDLLayouter layouter;
            PDLParagraphFormat paragraphFormat;
            IPDLTextPad activePad = this.getActivePad();
            PDLTextFormat textFormat = this.endedCustomizeTextFormat(activePad);
            if (textFormat != null) {
                activePad.setTextFormat(textFormat);
                this.setPreviousTextFormat(null);
            }
            if ((paragraphFormat = this.endedCustomizeParagraphFormat(activePad)) != null) {
                activePad.setParagraphFormat(paragraphFormat);
                this.setPreviousParagraphFormat(null);
            }
            if ((layouter = this.endedCustomizeLayouter(activePad)) != null) {
                activePad.setLayouter(layouter);
                this.setPreviousLayouter(null);
            }
        }
    }

    protected IPDLTextPad getActivePad() {
        if (this.localPad == null) {
            if (this.getParent() != null) {
                return ((PDLHtmlTag)this.getParent()).getActivePad();
            }
            return this.getPDEHandler().getPad();
        }
        return this.localPad;
    }

    protected IFontFactory getFontFactory() {
        return this.getPDEHandler().getFontFactory();
    }

    public HtmlElement getHtmlElement() {
        return this.htmlElement;
    }

    protected IPDLTextPad getLocalPad() {
        return this.localPad;
    }

    protected Logger getLog() {
        return LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    public PDLHtmlHandler getPDEHandler() {
        return (PDLHtmlHandler)this.getHandler();
    }

    public PDLTextHtmlParser getPDEParser() {
        return this.getPDEHandler().getPDEParser();
    }

    protected PDLLayouter getPreviousLayouter() {
        return this.previousLayouter;
    }

    protected PDLParagraphFormat getPreviousParagraphFormat() {
        return this.previousParagraphFormat;
    }

    protected PDLTextFormat getPreviousTextFormat() {
        return this.previousTextFormat;
    }

    protected IStyle getStyle() {
        if (this.style == null) {
            this.style = this.readStyle();
        }
        return this.style;
    }

    protected IStyleSheet getStyleSheet() {
        return this.getPDEHandler().getStyleSheet();
    }

    public TableSegment getTableRowParent() {
        throw new IllegalStateException(this + " can not be a table row parent");
    }

    public void handleOverflow(List overflow) throws PDLParseException {
    }

    public boolean isAfterTextLine() {
        return this.getPDEParser().isAfterTextLine();
    }

    protected boolean isBlock() {
        return this.getHtmlTag() == null || this.getHtmlTag().isBlock();
    }

    protected boolean isBreak() {
        return this.getHtmlTag() == null || this.getHtmlTag().isBreak();
    }

    protected boolean isCreateNewPad() {
        return this.isPageBreakInsideAvoid();
    }

    protected boolean isForcedBreak() {
        return false;
    }

    protected boolean isPageBreakInsideAvoid() {
        String breakInside = this.getStyle().getPropertyValue("page-break-inside");
        return "avoid".equalsIgnoreCase(breakInside);
    }

    protected boolean isParagraph() {
        return false;
    }

    public boolean isSimpleTag() {
        return false;
    }

    public void newLine(boolean forced) throws PDLParseException {
        this.getPDEParser().newLine(forced);
    }

    public void newPage() throws PDLParseException {
        this.getPDEParser().newPage();
    }

    public void newParagraph() throws PDLParseException {
        this.getPDEParser().newParagraph();
    }

    protected IStyle readStyle() {
        IStyleSheetParser ssParser;
        String rule;
        IStyle ssStyle = null;
        IStyle ruleStyle = null;
        IStyleSheet ss = this.getPDEHandler().getStyleSheet();
        if (ss != null) {
            ssStyle = ss.getStyle(this.getHtmlTag().getName(), this.getHtmlTag().getAttributes());
        }
        if ((rule = this.getHtmlTag().getAttribute("style")) != null && (ssParser = this.getPDEHandler().getStyleSheetParser()) != null) {
            try {
                ruleStyle = ssParser.parseStyle(rule);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (ssStyle == null) {
            if (ruleStyle == null) {
                return NullStyle.INSTANCE;
            }
            return ruleStyle;
        }
        if (ruleStyle == null) {
            return ssStyle;
        }
        CompositeStyle cs = new CompositeStyle();
        cs.addStyle(ruleStyle);
        cs.addStyle(ssStyle);
        return cs;
    }

    public void replayOverflow(List overflow) throws PDLParseException {
    }

    public void setAfterTextLine(boolean value) {
        this.getPDEParser().setAfterTextLine(value);
    }

    protected void setLocalPad(IPDLTextPad localPad) {
        this.localPad = localPad;
    }

    protected void setPreviousLayouter(PDLLayouter layouter) {
        this.previousLayouter = layouter;
    }

    protected void setPreviousParagraphFormat(PDLParagraphFormat paragraphState) {
        this.previousParagraphFormat = paragraphState;
    }

    protected void setPreviousTextFormat(PDLTextFormat textState) {
        this.previousTextFormat = textState;
    }

    public IHtmlTagImpl start(IHtmlTag htmlTag) throws PDLParseException {
        return this.getPDEHandler().getTagImplFactory().create(this.getHandler(), (IHtmlTagImpl)this, htmlTag);
    }

    public void started() throws PDLParseException {
        String breakBefore = this.getStyle().getPropertyValue("page-break-before");
        if ("always".equalsIgnoreCase(breakBefore)) {
            this.newPage();
        }
        if (this.isParagraph()) {
            this.newParagraph();
        } else if (this.isBreak()) {
            this.newLine(this.isForcedBreak());
        }
        this.startedPad();
    }

    protected PDLLayouter startedCustomizeLayouter(IPDLTextPad pad) {
        PDLLayouter result = pad.getLayouter();
        if (this.isPageBreakInsideAvoid()) {
            Rectangle2D oldRect = result.getBoundingBox();
            float width = (float)oldRect.getWidth();
            Rectangle2D.Float newRect = new Rectangle2D.Float(0.0f, 0.0f, width, 0.0f);
            result = new PDLLayouter(newRect);
            result.setPrimaryBorderPolicy(CBorderPolicy.FIX);
            result.setSecondaryBorderPolicy(CBorderPolicy.GROW);
        }
        return result;
    }

    protected PDLParagraphFormat startedCustomizeParagraphFormat(IPDLTextPad pad) {
        String halign;
        PDLParagraphFormat result = pad.getParagraphFormat();
        if (this.isBlock() && (halign = this.getHtmlTag().getAttribute("align")) != null) {
            result = result.copy();
            result.setHAlignment(PDLHtmlTag.convertAttributeHAlign(halign));
        }
        return result;
    }

    protected PDLTextFormat startedCustomizeTextFormat(IPDLTextPad pad) {
        float[] color;
        String colorString;
        PDLTextFormat result = pad.getTextFormat();
        CSSFontDefinition fontDefinition = CSSFontDefinition.createFromStyle(this.getStyle());
        if (fontDefinition.getFontFamily() != null) {
            PDFont font;
            if (pad.getTextFormat() == result) {
                result = result.copy();
            }
            if ((font = PDLCssTools.getFont(this.getPDEHandler().getPDEParser().getFontFactory(), result.getFont(), fontDefinition.getFontFamily())) != null) {
                result.setFont(font);
            } else {
                this.getLog().warn("font '" + fontDefinition.getFontFamily() + "' not available");
            }
        }
        if (fontDefinition.getFontSize() != null) {
            if (pad.getTextFormat() == result) {
                result = result.copy();
            }
            String fontSize = fontDefinition.getFontSize().toLowerCase();
            float fontSizeValue = PDLCssTools.getFontSize(result.getFontSize(), fontSize);
            result.setFontSize(fontSizeValue);
        }
        String fontStyle = fontDefinition.getFontStyle();
        String fontWeight = fontDefinition.getFontWeight();
        if (fontStyle != null || fontWeight != null) {
            if (pad.getTextFormat() == result) {
                result = result.copy();
            }
            PDFontStyle currentStyle = result.getFont().getLookupFontStyle();
            if (fontStyle == null) {
                fontStyle = currentStyle == PDFontStyle.ITALIC || currentStyle == PDFontStyle.BOLD_ITALIC ? "italic" : "normal";
            }
            if (fontWeight == null) {
                fontWeight = currentStyle == PDFontStyle.BOLD || currentStyle == PDFontStyle.BOLD_ITALIC ? "bold" : "normal";
            }
            try {
                PDFont newFont = this.getFontFactory().getRegularFlavor(result.getFont());
                if ("italic".equalsIgnoreCase(fontStyle) || "oblique".equalsIgnoreCase(fontStyle)) {
                    newFont = this.getFontFactory().getItalicFlavor(newFont);
                }
                if ("bold".equalsIgnoreCase(fontWeight)) {
                    newFont = this.getFontFactory().getBoldFlavor(newFont);
                }
                result.setFont(newFont);
            }
            catch (FontFactoryException newFont) {
                // empty catch block
            }
        }
        if ((colorString = this.getStyle().getPropertyValue("color")) != null && (color = PDLCssTools.getColor(colorString)) != null) {
            if (pad.getTextFormat() == result) {
                result = result.copy();
            }
            result.setColor(color);
        }
        return result;
    }

    protected final void startedPad() {
        IPDLTextPad pad = this.getActivePad();
        if (pad == null) {
            return;
        }
        PDLTextFormat newTextFormat = this.startedCustomizeTextFormat(pad);
        PDLParagraphFormat newParagraphFormat = this.startedCustomizeParagraphFormat(pad);
        PDLLayouter newLayouter = this.startedCustomizeLayouter(pad);
        if (this.isCreateNewPad()) {
            PDLTextPad newPad = new PDLTextPad(newTextFormat, newParagraphFormat, newLayouter);
            this.setLocalPad(newPad);
        } else {
            if (newTextFormat != pad.getTextFormat()) {
                this.setPreviousTextFormat(pad.getTextFormat());
                pad.setTextFormat(newTextFormat);
            }
            if (newParagraphFormat != pad.getParagraphFormat()) {
                this.setPreviousParagraphFormat(pad.getParagraphFormat());
                pad.setParagraphFormat(newParagraphFormat);
            }
            if (newLayouter != pad.getLayouter()) {
                this.setPreviousLayouter(pad.getLayouter());
                pad.setLayouter(newLayouter);
            }
        }
    }

    public void text(char[] data) throws PDLParseException {
        this.text(data, 0, data.length);
    }

    public void text(char[] data, int start, int length) throws PDLParseException {
        try {
            PDLTextHtmlParser r = this.getPDEParser();
            if (r.isLineMode()) {
                r.writeLine(new CharArrayReader(data, start, length));
            } else {
                r.writeLineHyphenate(new CharArrayReader(data, start, length));
            }
        }
        catch (IOException e) {
            throw new PDLParseException(e.getMessage());
        }
    }
}

