/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.parser;

import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.font.outlet.FontQuery;
import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.font.outlet.IFontQuery;
import java.util.StringTokenizer;

public final class PDLHtmlTools {
    public static final double HTML_MINFONTSIZE = 1.0;
    public static final double HTML_MAXFONTSIZE = 7.0;
    private static final float BASE_SIZE = 12.0f;

    public static float computeFontSizePt(int size) {
        double htmlSize = Math.max(Math.min((double)size, 7.0), 1.0);
        return (float)(12.0 * (1.0 + (htmlSize - 3.0) / 3.0));
    }

    public static PDFont getFont(IFontFactory factory, PDFont previous, String fontDefinition) {
        if (fontDefinition == null) {
            return previous;
        }
        StringTokenizer st = new StringTokenizer(fontDefinition, ",");
        while (st.hasMoreTokens()) {
            String currentDefinition = st.nextToken().trim();
            if (currentDefinition.startsWith("\"") && currentDefinition.endsWith("\"") || currentDefinition.startsWith("'") && currentDefinition.endsWith("'")) {
                currentDefinition = currentDefinition.substring(1, currentDefinition.length() - 1);
            }
            FontQuery template = new FontQuery();
            template.setOverrideFontType("Any");
            template.setOverrideFontName(currentDefinition);
            template.setOverrideFontFamilyName(currentDefinition);
            template.setOverrideFontStyle(PDFontStyle.REGULAR);
            try {
                PDFont newFont = factory.getFont((IFontQuery)template);
                if (newFont == null) continue;
                return newFont;
            }
            catch (FontFactoryException fontFactoryException) {
            }
        }
        return previous;
    }

    public static float getFontSize(float oldSize, String sizeDefinition) {
        if (sizeDefinition == null) {
            return oldSize;
        }
        if ((sizeDefinition = sizeDefinition.trim()).startsWith("+")) {
            float delta = Float.parseFloat(sizeDefinition.substring(1));
            return oldSize + PDLHtmlTools.computeFontSizePt((int)delta);
        }
        if (sizeDefinition.startsWith("-")) {
            float delta = Float.parseFloat(sizeDefinition.substring(1));
            return oldSize - PDLHtmlTools.computeFontSizePt((int)delta);
        }
        StringBuffer sb = new StringBuffer();
        String sizeUnit = null;
        for (int i = 0; i < sizeDefinition.length(); ++i) {
            char current = sizeDefinition.charAt(i);
            if (!Character.isDigit(current) && current != '.') {
                sizeUnit = sizeDefinition.substring(i);
                break;
            }
            sb.append(current);
        }
        String sizeNumber = sb.toString();
        float size = Float.parseFloat(sizeNumber);
        if (sizeUnit == null) {
            size = PDLHtmlTools.computeFontSizePt((int)size);
        } else if ("pt".equalsIgnoreCase(sizeUnit)) {
            size = Float.parseFloat(sizeNumber);
        }
        return size;
    }

    private PDLHtmlTools() {
    }
}

