/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.parser;

import de.intarsys.html.IHtmlHandler;
import de.intarsys.html.IHtmlParser;
import de.intarsys.html.impl.tagsoup.TagSoupParser;
import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.parser.PDLAbstractDocumentParser;
import de.intarsys.pdf.layout.parser.PDLParseException;
import de.intarsys.pdf.layout.parser.PDLStopParse;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

public class PDLTextHtmlParser
extends PDLAbstractDocumentParser {
    private PDLHtmlHandler handler;
    private IFontFactory fontFactory;
    private ILocator baseLocator;
    private boolean afterTextLine = true;

    public PDLTextHtmlParser(IFontFactory fontFactory) {
        this.fontFactory = fontFactory;
    }

    @Override
    protected void basicParseFragment(Reader r) throws IOException, PDLParseException {
        this.handler = new PDLHtmlHandler(this);
        IHtmlParser parser = this.createParser(this.handler);
        try {
            parser.parse(r);
        }
        catch (PDLStopParse pDLStopParse) {
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PDLParseException(e);
        }
    }

    protected IHtmlParser createParser(PDLHtmlHandler handler) throws PDLParseException {
        return new TagSoupParser((IHtmlHandler)handler);
    }

    @Override
    protected IPDLTextPad getActivePad() {
        return this.getPDEHandler().getActivePad();
    }

    public ILocator getBaseLocator() {
        return this.baseLocator;
    }

    public IFontFactory getFontFactory() {
        return this.fontFactory;
    }

    protected PDLHtmlHandler getPDEHandler() {
        return this.handler;
    }

    @Override
    protected void handleOverflow(List overflow) throws PDLParseException {
        this.getPDEHandler().handleOverflow(overflow);
        super.handleOverflow(overflow);
    }

    protected boolean isAfterTextLine() {
        return this.afterTextLine;
    }

    @Override
    protected void replayOverflow(List overflow) throws PDLParseException {
        this.getPDEHandler().replayOverflow(overflow);
        super.replayOverflow(overflow);
    }

    public ILocator resolveResource(String path) {
        try {
            path = new URI(path).getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        File file = new File(path);
        if (file.isAbsolute() || this.getBaseLocator() == null) {
            return new FileLocator(path);
        }
        return this.getBaseLocator().getChild(path);
    }

    protected void setAfterTextLine(boolean afterTextLine) {
        this.afterTextLine = afterTextLine;
    }

    public void setBaseLocator(ILocator context) {
        this.baseLocator = context;
    }

    @Override
    public void setPad(IPDLTextPad pad) {
        super.setPad(pad);
        if (this.getPDEHandler() != null) {
            this.getPDEHandler().setPad(pad);
        }
    }

    @Override
    protected void writeLine(Reader reader) throws IOException, PDLParseException {
        this.setWhitespaceFound(false);
        super.writeLine(reader);
    }

    @Override
    protected void writeLineHyphenate(Reader reader) throws IOException, PDLParseException {
        BufferedReader bReader = new BufferedReader(reader, 10);
        int i = bReader.read();
        while (i != -1) {
            block10: {
                boolean ws;
                char c;
                block11: {
                    block9: {
                        c = (char)i;
                        ws = this.isWhitespace(c);
                        if (!ws) break block9;
                        if (this.isWhitespaceFound()) break block10;
                        this.setWhitespaceFound(true);
                        c = ' ';
                        break block11;
                    }
                    this.setAfterTextLine(true);
                    this.setWhitespaceFound(false);
                }
                if (this.isNoLineBreak()) {
                    this.putBuffer(c);
                } else {
                    if (this.isCharMode() || this.isBreakBefore(c)) {
                        this.flush();
                    }
                    this.putBuffer(c);
                    if (ws) {
                        this.flush();
                    } else if (this.isBreakAfter(c)) {
                        int j;
                        bReader.mark(3);
                        char[] lookahead = new char[3];
                        int lookaheadRead = 0;
                        do {
                            j = bReader.read();
                            lookahead[lookaheadRead++] = (char)j;
                        } while (j != -1 && lookaheadRead != lookahead.length);
                        bReader.reset();
                        if (this.isBreakBeforeContent(c, lookahead, lookaheadRead)) {
                            this.flush();
                        }
                    }
                }
            }
            i = bReader.read();
        }
    }
}

