/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.tag;

import de.intarsys.html.IHtmlTag;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTools;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.pdf.layout.parser.PDLParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDLHtmlTagBASEFONT
extends PDLHtmlTag {
    private static final Logger Log = LoggerFactory.getLogger(PDLHtmlTagBASEFONT.class);

    protected PDLHtmlTagBASEFONT(PDLHtmlHandler handler, PDLHtmlTag parent, IHtmlTag htmlTag) {
        super(handler, parent, htmlTag, parent.getHtmlElement());
    }

    @Override
    public void started() throws PDLParseException {
        super.started();
        IPDLTextPad pad = this.getPDEParser().getPad();
        PDLTextFormat textFormat = pad.getTextFormat().copy();
        String fontDefinition = this.getHtmlTag().getAttribute("face");
        PDFont font = PDLHtmlTools.getFont(this.getPDEHandler().getPDEParser().getFontFactory(), textFormat.getFont(), fontDefinition);
        if (font == null) {
            Log.warn("font '" + fontDefinition + "' not available");
        } else {
            textFormat.setFont(font);
            String sizeDefinition = this.getHtmlTag().getAttribute("size");
            float fontSize = PDLHtmlTools.getFontSize(textFormat.getFontSize(), sizeDefinition);
            textFormat.setFontSize(fontSize);
            this.getPDEHandler().setTextFormat(textFormat);
        }
    }
}

