/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.tag;

import de.intarsys.html.IHtmlTag;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.layout.element.PDLBackgroundImage;
import de.intarsys.pdf.layout.html.model.HtmlDocument;
import de.intarsys.pdf.layout.html.parser.CSSPosition;
import de.intarsys.pdf.layout.html.parser.PDLCssTools;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLLayouter;
import de.intarsys.pdf.layout.parser.PDLParseException;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.tools.enumeration.common.EnumScaleWhen;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import java.util.List;

public class PDLHtmlTagBODY
extends PDLHtmlTag {
    protected PDLHtmlTagBODY(PDLHtmlHandler handler, PDLHtmlTag parent, IHtmlTag htmlTag) {
        super(handler, parent, htmlTag, new HtmlDocument());
    }

    @Override
    protected boolean isBlock() {
        return false;
    }

    @Override
    protected boolean isBreak() {
        return false;
    }

    @Override
    protected boolean isCreateNewPad() {
        return false;
    }

    @Override
    protected boolean isForcedBreak() {
        return false;
    }

    @Override
    protected boolean isParagraph() {
        return false;
    }

    protected void layoutBackground() throws PDLParseException {
        String backgroundSrc = null;
        CSSPosition pos = null;
        PDLBackgroundImage.EnumRepeat backgroundRepeat = null;
        String cssSrc = this.getStyle().getPropertyValue("background-image");
        if (cssSrc == null) {
            backgroundSrc = this.getHtmlTag().getAttribute("background");
        } else {
            if (cssSrc.toLowerCase().startsWith("url(") && (cssSrc = cssSrc.substring(4)).endsWith(")")) {
                cssSrc = cssSrc.substring(0, cssSrc.length() - 1);
            }
            backgroundSrc = cssSrc;
            backgroundRepeat = (PDLBackgroundImage.EnumRepeat)PDLBackgroundImage.EnumRepeat.META.getItemOrDefault(this.getStyle().getPropertyValue("background-repeat"));
            String position = this.getStyle().getPropertyValue("background-position");
            pos = new CSSPosition(position);
        }
        if (backgroundSrc == null) {
            return;
        }
        PDLBackgroundImage image = new PDLBackgroundImage();
        image.setSource(this.getPDEParser().resolveResource(backgroundSrc));
        image.setRepeat(backgroundRepeat);
        Iterator iScale = this.getStyle().getPropertyValues("background-scale").iterator();
        EnumScaleWhen scale = iScale.hasNext() ? (EnumScaleWhen)EnumScaleWhen.META.getItemOrDefault((String)iScale.next()) : (EnumScaleWhen)EnumScaleWhen.META.getDefault();
        PDLBackgroundImage.EnumScaleMode scaleMode = iScale.hasNext() ? (PDLBackgroundImage.EnumScaleMode)PDLBackgroundImage.EnumScaleMode.META.getItemOrDefault((String)iScale.next()) : (PDLBackgroundImage.EnumScaleMode)PDLBackgroundImage.EnumScaleMode.META.getDefault();
        image.setScale(scale);
        image.setScaleMode(scaleMode);
        PDPage page = (PDPage)this.getPDEParser().getAttribute("page");
        if (page != null && "fixed".equals(this.getStyle().getPropertyValue("background-attachment"))) {
            CDSRectangle bbox = page.getMediaBox().copy().normalize();
            image.setBounds(bbox.toRectangle());
        } else {
            image.setBounds(this.getActivePad().getLayouter().getBoundingBox());
        }
        image.setPosition(pos);
        this.getActivePad().layoutElement(image);
    }

    @Override
    public void replayOverflow(List overflow) throws PDLParseException {
        this.layoutBackground();
        super.replayOverflow(overflow);
    }

    @Override
    public void started() throws PDLParseException {
        float width = (float)this.getActivePad().getLayouter().getBoundingBox().getWidth();
        this.getHtmlElement().setWidth(width);
        super.started();
        this.layoutBackground();
    }

    @Override
    protected PDLLayouter startedCustomizeLayouter(IPDLTextPad pad) {
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        float marginTop = 0.0f;
        float marginBottom = 0.0f;
        Rectangle2D oldBounds = pad.getLayouter().getBoundingBox();
        String margin = this.getStyle().getPropertyValue("margin-left");
        marginLeft = PDLCssTools.parseMargin(oldBounds.getWidth(), margin);
        margin = this.getStyle().getPropertyValue("margin-bottom");
        marginBottom = PDLCssTools.parseMargin(oldBounds.getHeight(), margin);
        margin = this.getStyle().getPropertyValue("margin-right");
        marginRight = PDLCssTools.parseMargin(oldBounds.getWidth(), margin);
        margin = this.getStyle().getPropertyValue("margin-top");
        marginTop = PDLCssTools.parseMargin(oldBounds.getHeight(), margin);
        Rectangle2D.Double newBounds = new Rectangle2D.Double(oldBounds.getMinX() + (double)marginLeft, oldBounds.getMinY() + (double)marginBottom, oldBounds.getWidth() - (double)marginLeft - (double)marginRight, oldBounds.getHeight() - (double)marginBottom - (double)marginTop);
        this.getHtmlElement().setWidth((float)((RectangularShape)newBounds).getWidth());
        PDLLayouter result = new PDLLayouter(newBounds);
        return result;
    }
}

