/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.tag;

import de.intarsys.html.IHtmlHandler;
import de.intarsys.html.IHtmlTag;
import de.intarsys.html.IHtmlTagImpl;
import de.intarsys.html.IHtmlTagImplFactory;
import de.intarsys.pdf.layout.html.annotation.PDLHtmlTagA;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagB;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagBASEFONT;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagBODY;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagBR;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagCENTER;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagCOL;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagCOLGROUP;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagDIV;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagDefault;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagFONT;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagHEAD;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagHTML;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagHx;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagI;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagIMG;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagLI;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagLINK;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagNOBR;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagOL;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagP;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagPRE;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagSPAN;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagSPECIAL;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagSTRIKE;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagSTYLE;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagSUB;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagSUP;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagTABLE;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagTBODY;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagTD;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagTFOOT;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagTH;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagTHEAD;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagTITLE;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagTR;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagU;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagUL;
import de.intarsys.tools.component.SingletonClass;
import java.util.ArrayList;
import java.util.List;

@SingletonClass
public class PDLHtmlTagFactory
implements IHtmlTagImplFactory {
    private static final List TAG_FACTORIES = new ArrayList();
    private static final PDLHtmlTagFactory Active = new PDLHtmlTagFactory();

    public static PDLHtmlTagFactory getActive() {
        return Active;
    }

    private PDLHtmlTagFactory() {
        this.registerStandardFactory();
    }

    public IHtmlTagImpl create(IHtmlHandler htmlHandler, IHtmlTagImpl parentTag, IHtmlTag htmlTag) {
        for (IHtmlTagImplFactory factory : TAG_FACTORIES) {
            IHtmlTagImpl tag = factory.create(htmlHandler, parentTag, htmlTag);
            if (tag == null) continue;
            return tag;
        }
        PDLHtmlHandler handler = (PDLHtmlHandler)htmlHandler;
        PDLHtmlTag parent = (PDLHtmlTag)parentTag;
        return new PDLHtmlTagDefault(handler, parent, htmlTag);
    }

    protected void registerStandardFactory() {
        IHtmlTagImplFactory standardTagFactory = new IHtmlTagImplFactory(){

            public IHtmlTagImpl create(IHtmlHandler htmlHandler, IHtmlTagImpl parentTag, IHtmlTag htmlTag) {
                PDLHtmlHandler handler = (PDLHtmlHandler)htmlHandler;
                PDLHtmlTag parent = (PDLHtmlTag)parentTag;
                if ("html".equals(htmlTag.getName())) {
                    return new PDLHtmlTagHTML(handler, parent, htmlTag);
                }
                if ("head".equals(htmlTag.getName())) {
                    return new PDLHtmlTagHEAD(handler, parent, htmlTag);
                }
                if ("body".equals(htmlTag.getName())) {
                    return new PDLHtmlTagBODY(handler, parent, htmlTag);
                }
                if ("title".equals(htmlTag.getName())) {
                    return new PDLHtmlTagTITLE(handler, parent, htmlTag);
                }
                if ("style".equals(htmlTag.getName())) {
                    return new PDLHtmlTagSTYLE(handler, parent, htmlTag);
                }
                if ("link".equals(htmlTag.getName())) {
                    return new PDLHtmlTagLINK(handler, parent, htmlTag);
                }
                if ("b".equals(htmlTag.getName())) {
                    return new PDLHtmlTagB(handler, parent, htmlTag);
                }
                if ("strong".equals(htmlTag.getName())) {
                    return new PDLHtmlTagB(handler, parent, htmlTag);
                }
                if ("i".equals(htmlTag.getName())) {
                    return new PDLHtmlTagI(handler, parent, htmlTag);
                }
                if ("em".equals(htmlTag.getName())) {
                    return new PDLHtmlTagI(handler, parent, htmlTag);
                }
                if ("u".equals(htmlTag.getName())) {
                    return new PDLHtmlTagU(handler, parent, htmlTag);
                }
                if ("strike".equals(htmlTag.getName())) {
                    return new PDLHtmlTagSTRIKE(handler, parent, htmlTag);
                }
                if ("sub".equals(htmlTag.getName())) {
                    return new PDLHtmlTagSUB(handler, parent, htmlTag);
                }
                if ("sup".equals(htmlTag.getName())) {
                    return new PDLHtmlTagSUP(handler, parent, htmlTag);
                }
                if ("br".equals(htmlTag.getName())) {
                    return new PDLHtmlTagBR(handler, parent, htmlTag);
                }
                if ("table".equals(htmlTag.getName())) {
                    return new PDLHtmlTagTABLE(handler, parent, htmlTag);
                }
                if ("thead".equals(htmlTag.getName())) {
                    return new PDLHtmlTagTHEAD(handler, parent, htmlTag);
                }
                if ("tfoot".equals(htmlTag.getName())) {
                    return new PDLHtmlTagTFOOT(handler, parent, htmlTag);
                }
                if ("tbody".equals(htmlTag.getName())) {
                    return new PDLHtmlTagTBODY(handler, parent, htmlTag);
                }
                if ("tr".equals(htmlTag.getName())) {
                    return new PDLHtmlTagTR(handler, parent, htmlTag);
                }
                if ("td".equals(htmlTag.getName())) {
                    return new PDLHtmlTagTD(handler, parent, htmlTag);
                }
                if ("th".equals(htmlTag.getName())) {
                    return new PDLHtmlTagTH(handler, parent, htmlTag);
                }
                if ("font".equals(htmlTag.getName())) {
                    return new PDLHtmlTagFONT(handler, parent, htmlTag);
                }
                if ("basefont".equals(htmlTag.getName())) {
                    return new PDLHtmlTagBASEFONT(handler, parent, htmlTag);
                }
                if ("p".equals(htmlTag.getName())) {
                    return new PDLHtmlTagP(handler, parent, htmlTag);
                }
                if ("div".equals(htmlTag.getName())) {
                    return new PDLHtmlTagDIV(handler, parent, htmlTag);
                }
                if ("span".equals(htmlTag.getName())) {
                    return new PDLHtmlTagSPAN(handler, parent, htmlTag);
                }
                if ("pre".equals(htmlTag.getName())) {
                    return new PDLHtmlTagPRE(handler, parent, htmlTag);
                }
                if ("ol".equals(htmlTag.getName())) {
                    return new PDLHtmlTagOL(handler, parent, htmlTag);
                }
                if ("ul".equals(htmlTag.getName())) {
                    return new PDLHtmlTagUL(handler, parent, htmlTag);
                }
                if ("li".equals(htmlTag.getName())) {
                    return new PDLHtmlTagLI(handler, parent, htmlTag);
                }
                if ("colgroup".equals(htmlTag.getName())) {
                    return new PDLHtmlTagCOLGROUP(handler, parent, htmlTag);
                }
                if ("col".equals(htmlTag.getName())) {
                    return new PDLHtmlTagCOL(handler, parent, htmlTag);
                }
                if ("img".equals(htmlTag.getName())) {
                    return new PDLHtmlTagIMG(handler, parent, htmlTag);
                }
                if ("special".equals(htmlTag.getName())) {
                    return new PDLHtmlTagSPECIAL(handler, parent, htmlTag);
                }
                if ("nobr".equals(htmlTag.getName())) {
                    return new PDLHtmlTagNOBR(handler, parent, htmlTag);
                }
                if ("center".equals(htmlTag.getName())) {
                    return new PDLHtmlTagCENTER(handler, parent, htmlTag);
                }
                if ("a".equals(htmlTag.getName())) {
                    return new PDLHtmlTagA(handler, parent, htmlTag);
                }
                if ("h1".equals(htmlTag.getName())) {
                    return new PDLHtmlTagHx(handler, parent, htmlTag);
                }
                if ("h2".equals(htmlTag.getName())) {
                    return new PDLHtmlTagHx(handler, parent, htmlTag);
                }
                if ("h3".equals(htmlTag.getName())) {
                    return new PDLHtmlTagHx(handler, parent, htmlTag);
                }
                if ("h4".equals(htmlTag.getName())) {
                    return new PDLHtmlTagHx(handler, parent, htmlTag);
                }
                if ("h5".equals(htmlTag.getName())) {
                    return new PDLHtmlTagHx(handler, parent, htmlTag);
                }
                if ("h6".equals(htmlTag.getName())) {
                    return new PDLHtmlTagHx(handler, parent, htmlTag);
                }
                return null;
            }
        };
        this.registerTagFactory(standardTagFactory);
    }

    public void registerTagFactory(IHtmlTagImplFactory factory) {
        TAG_FACTORIES.add(factory);
    }

    public void removeTagFactory(IHtmlTagImplFactory factory) {
        TAG_FACTORIES.remove(factory);
    }
}

