/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.tag;

import de.intarsys.html.IHtmlTag;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTools;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLTextFormat;

public class PDLHtmlTagHx
extends PDLHtmlTag {
    protected PDLHtmlTagHx(PDLHtmlHandler handler, PDLHtmlTag parent, IHtmlTag htmlTag) {
        super(handler, parent, htmlTag, parent.getHtmlElement());
    }

    protected float calculateFontSize() {
        String tagName = this.getHtmlTag().getName();
        String headerType = tagName.substring(1);
        int headerTypeInt = Integer.parseInt(headerType);
        int fontSize = 7 - headerTypeInt;
        return PDLHtmlTools.computeFontSizePt(fontSize);
    }

    @Override
    protected boolean isParagraph() {
        return true;
    }

    @Override
    protected PDLTextFormat startedCustomizeTextFormat(IPDLTextPad pad) {
        PDLTextFormat result = super.startedCustomizeTextFormat(pad);
        if (pad.getTextFormat() == result) {
            result = result.copy();
        }
        try {
            PDFont newFont = this.getFontFactory().getBoldFlavor(result.getFont());
            result.setFont(newFont);
        }
        catch (FontFactoryException newFont) {
            // empty catch block
        }
        float fontSize = this.calculateFontSize();
        result.setFontSize(fontSize);
        return result;
    }
}

